/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Yahoo {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
    private SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd");

    Yahoo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Quote> getQuotes(String symbol) throws IOException {
        Date dt = new Date(System.currentTimeMillis());
        String yyyy_mm_dd = this.formatter.format(dt);
        String curr_year = yyyy_mm_dd.substring(0, 4);
        String curr_month = yyyy_mm_dd.substring(5, 7);
        String curr_date = yyyy_mm_dd.substring(8, 10);
        int int_from_year = Integer.parseInt(curr_year) - 5;
        String tickerSymbol = URLEncoder.encode(symbol, "US-ASCII");
        String targetURL = "http://chart.yahoo.com/table.csv?s=" + tickerSymbol + "&a=" + curr_month + "&b=" + curr_date + "&c=" + int_from_year + "&d=" + curr_month + "&e=" + curr_date + "&f=" + curr_year + "&g=d&q=q&y=0&z=" + tickerSymbol + "&x=.csv";
        URL url = new URL(targetURL);
        URLConnection connection = url.openConnection();
        System.out.println("TargetUrl is:" + targetURL);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String line = in.readLine();
            ArrayList<Quote> result = new ArrayList<Quote>();
            while ((line = in.readLine()) != null) {
                result.add(new Quote(line, this.parser));
            }
            ArrayList<Quote> arrayList = result;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] args) throws IOException {
        Yahoo yahoo = new Yahoo();
        List<Quote> quotes = yahoo.getQuotes("INTC");
        System.out.println(quotes.size());
    }

    public static class Quote {
        private Date date;
        private float open;
        private float close;
        private float low;
        private float high;
        private float volume;
        private float adjClose;

        Quote(String quote, SimpleDateFormat format) throws IOException {
            try {
                String[] token = quote.split(",");
                this.date = format.parse(token[0]);
                this.open = Float.valueOf(token[1]).floatValue();
                this.high = Float.valueOf(token[2]).floatValue();
                this.low = Float.valueOf(token[3]).floatValue();
                this.close = Float.valueOf(token[4]).floatValue();
                this.volume = Float.valueOf(token[5]).floatValue();
                this.adjClose = Float.valueOf(token[6]).floatValue();
            }
            catch (ParseException x) {
                throw new IOException("Bad line read: " + quote, x);
            }
        }

        public float getAdjClose() {
            return this.adjClose;
        }

        public float getClose() {
            return this.close;
        }

        public Date getDate() {
            return this.date;
        }

        public float getHigh() {
            return this.high;
        }

        public float getLow() {
            return this.low;
        }

        public float getOpen() {
            return this.open;
        }

        public float getVolume() {
            return this.volume;
        }
    }
}

