/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting.jython;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.freehep.util.ClasspathUtilities;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.pattern.PatternUtils;
import org.python.Version;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveConsole;
import org.python.util.PythonInterpreter;

public class JythonScriptExecutorUtils {
    public static InputStream getScriptInputStream(String script) throws FileNotFoundException {
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)script);
        if (is == null) {
            is = new FileInputStream(script);
        }
        return is;
    }

    public static void executeScript(String scriptPath, String ... args) throws FileNotFoundException {
        InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
        JythonScriptExecutorUtils.executeScript(is, scriptPath, System.out, args);
    }

    public static void executeScript(String scriptPath, OutputStream out, String ... args) throws FileNotFoundException, IOException {
        try (InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);){
            JythonScriptExecutorUtils.executeScript(is, scriptPath, out, args);
        }
    }

    public static void executeScript(InputStream is, String ... args) {
        JythonScriptExecutorUtils.executeScript(is, (OutputStream)System.out, args);
    }

    public static void executeInteractive() {
        try (InteractiveConsole pyInterpreter = new InteractiveConsole();){
            System.out.println("CCS jython " + Version.PY_VERSION);
            InputStream is = BootstrapResourceUtils.getBootstrapResource((String)"profile.jy");
            if (is != null) {
                pyInterpreter.execfile(is, "profile.jy");
            }
            pyInterpreter.interact(null, null);
            System.out.println();
        }
    }

    public static void executeScript(InputStream is, OutputStream out, String ... args) {
        JythonScriptExecutorUtils.executeScript(is, null, out, args);
    }

    public static void executeScript(InputStream is, String fileName, OutputStream out, String ... args) {
        try (PythonInterpreter pyInterpreter = new PythonInterpreter(null, new PySystemState());){
            pyInterpreter.setOut(out);
            pyInterpreter.setErr(out);
            pyInterpreter.exec(JythonScriptExecutorUtils.getArgumentSettingCode(fileName, args));
            PyCode code = pyInterpreter.compile((Reader)new InputStreamReader(is), fileName);
            pyInterpreter.exec((PyObject)code);
        }
    }

    public static Properties loadPythonProperties() {
        Properties postProps = new Properties();
        postProps.setProperty("python.packages.paths", "full.java.class.path,sun.boot.class.path,app.class.path");
        postProps.setProperty("python.cachedir", PatternUtils.resolvePattern((String)BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.console.jython.cachedir", "%W/cachedir")));
        postProps.setProperty("python.verbose", "warning");
        postProps.setProperty("python.cachedir.skip", "false");
        postProps.setProperty("python.console", "org.python.util.JLineConsole");
        List bootstrapDirs = BootstrapResourceUtils.getOrderedListOfResourceDirectories();
        String pathSeparator = System.getProperty("path.separator");
        String pythonPath = String.join((CharSequence)pathSeparator, bootstrapDirs);
        ClasspathUtilities.setFullSystemClasspathInSystemProperty((String)"full.java.class.path");
        postProps.setProperty("python.path", pythonPath + pathSeparator + System.getProperty("java.class.path"));
        return postProps;
    }

    public static String getArgumentSettingCode(String fileName, String ... args) {
        StringBuilder arguments = new StringBuilder("['");
        arguments.append(fileName == null ? "" : fileName).append("'");
        for (String arg : args) {
            arguments.append(",'").append(arg).append("'");
        }
        arguments.append("]");
        return "import sys;\nsys.argv=" + arguments + "\n";
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JythonScriptExecutorUtils.executeScript("org/lsst/ccs/scripting/jython/sendingCommands.py", (OutputStream)out, new String[0]);
        System.out.println(out.toString());
    }

    static {
        PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)JythonScriptExecutorUtils.loadPythonProperties(), null);
    }
}

