/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.freehep.util.Value;
import org.lsst.ccs.subsystems.shutter.sim.MotorPosition;
import util.ListenerList;

public class MotorHistory
implements DiscretePlotData,
MutablePlotData {
    private final List<MotorSpeed> history = new ArrayList<MotorSpeed>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Acceleration", "Velocity", "Position"};

    public void MotorHistory() {
    }

    public void reset() {
        this.history.clear();
        this.firePlotDataChanged();
    }

    public void addData(Stream<MotorPosition> pos) {
        MotorPosition[] apos = (MotorPosition[])pos.toArray(MotorPosition[]::new);
        double vscale = Arrays.stream(apos).mapToDouble(p -> Math.abs(p.getVelocity())).max().orElse(1.0);
        double ascale = Arrays.stream(apos).mapToDouble(p -> Math.abs(p.getAcceleration())).max().orElse(1.0);
        Arrays.stream(apos).forEach(p -> this.history.add(new MotorSpeed(1.0E-6 * (double)p.getTime(), p.getAcceleration() / ascale, p.getVelocity() / vscale, p.getPosition())));
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        MotorSpeed speed = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(speed.getDate());
                break;
            }
            case 1: {
                value.set(speed.getAcceleration());
                break;
            }
            case 2: {
                value.set(speed.getVelocity());
                break;
            }
            case 3: {
                value.set(speed.getPosition());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor History";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    private static class MotorSpeed {
        private final double date;
        private final double acceleration;
        private final double velocity;
        private final double position;

        public MotorSpeed(double date, double acceleration, double velocity, double position) {
            this.date = date;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getDate() {
            return this.date;
        }

        public double getPosition() {
            return this.position;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }
}

