/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import util.ListenerList;

public class HallSensorHistory
implements DiscretePlotData,
MutablePlotData {
    private final List<HallData> history = new ArrayList<HallData>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double ERROR = 0.02;

    public void HallSensorHistory() {
    }

    public void reset() {
        this.history.clear();
        this.firePlotDataChanged();
    }

    public void addData(List<HallTransition> trans, long timeOrigin) {
        trans.forEach(h -> {
            double t = 1.0E-6 * (double)(h.getTransitionTime() - timeOrigin);
            HallData d = new HallData(t, h.getRelPosition(), ERROR);
            this.history.add(d);
        });
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        HallData transition = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(transition.getTime());
                break;
            }
            case 1: {
                value.set(transition.getPosition());
                break;
            }
            case 2: {
                value.set(transition.getError());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Hall Sensor History";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    private static class HallData {
        private final double time;
        private final double position;
        private final double error;

        public HallData(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

