package org.lsst.ccs.subsystem.shutter.common;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Defines enumerators for each possible shutter unit and determines which one is being used
 * by examining the name of the configuration of this subsystem. Not thread safe.
 * @author tether
 */
public enum ShutterUnit {
    SHUTTER01,
    SHUTTER02;

    private static final Logger LOG = Logger.getLogger(ShutterUnit.class.getName());
    
    private static ShutterUnit THIS_UNIT = null;

    public static void setThisUnit(final String configName) {
        if (configName.endsWith("01")) {
            THIS_UNIT = SHUTTER01;
        }
        else if (configName.endsWith("02")) {
            THIS_UNIT = SHUTTER02;
        }
        else {
            LOG.log(Level.WARNING,
                "Configuration name doesn't end in '01' or '02', will assume shutter unit is 1.");
            THIS_UNIT = SHUTTER01;
        }        
    }
    /**
     * Tells which shutter unit is being used.
     * @return The enumeration for the unit.
     */
    public static ShutterUnit getThisUnit() {return THIS_UNIT;}

}
