package org.lsst.ccs.subsystem.shutter.common;

/**
 * Represents the two sides of the camera X axis.
 * @author tether
 */
public enum ShutterSide {

    /** The -X side. */
    MINUSX(Constants.MAX_STROKE_LENGTH, 0.0),
    
    /** The +X side. */
    PLUSX(0.0, Constants.MAX_STROKE_LENGTH);

    private final double range;

    ShutterSide(double home, double extended) {
        this.range = extended - home;
    }

    /**
     * Gets the side opposite to this side.
     * @return the opposite side
     */
    public ShutterSide opposite() {
        return (this == PLUSX) ? MINUSX : PLUSX;
    }

    public static ShutterSide fromAxis(final Axis ax) {
        return ax.isPlusXSide() ? PLUSX : MINUSX;
    }

    public double normalizePosition(double absolute) {
        final double scaled = absolute / range;
        return range < 0.0 ? 1.0 + scaled : scaled;
    }
}
