package org.lsst.ccs.subsystem.shutter.common;

/**
 * A set of names for the RTD readings sent as part of the
 * {@code ShutterStatus} message. See JIRA LSSTCCSSHUTTER-125 and -139.
 * 
 * @author tether
 */
public enum RTD {
    
    /** The RTD for the +X motor enclosure, designated SHT-SHT-RTD-00 in circuit diagrams. */
    PLUSX_MOTOR(0),

    /** The RTD for the -X motor enclosure, designated SHT-SHT-RTD-01 in circuit diagrams. */
    MINUSX_MOTOR(1),

    /** The RTD for the control enclosure, designated SHT-SHT-RTD-02 in circuit diagrams. */
    CONTROL_BOX(2);    
    
    private final int index;

    private RTD(final int index) {
        this.index = index;
    }

    /**
     * Gets the index of the sensor value in the array in the status message.
     * @return The index.
     */
    public int getIndex() {
        return index;
    }
    
    /**
     * Converts the raw value read from the sensor to degrees Celsius.
     * @param rawValue the raw sensor reading gotten from the shutter PLC.
     * @return The temperature in degrees C.
     */
    public static double rawToCelsius(final int rawValue) {
        // We assume that the readout came from a Beckhoff EL3214 channel operating in the default
        // mode: Pt100, 3-wire connection, signed presentation, normal resolution, manufacturer's
        // calibration. In that case the raw value is just the temperature in tenths of a degree C.
        return rawValue / 10.0;
    }
}
