package org.lsst.ccs.subsystem.shutter.common;

import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 ***************************************************************************
 **
 **  Immutable class containing the data for a single position encoder sample.
 **
 **  @author Owen Saxton
 **  @author tether
 **
 ***************************************************************************
 */
public final class EncoderSample implements Serializable, TimeOrdered {

    private static final long serialVersionUID = 2L;

    final CCSTimeStamp time;
    final double   position; // Encoder position in mm.

    /**
     * Constructs from field values.
     * @param time        the time at which the sample was taken.
     * @param position    the encoder position in mm.
     */
    public EncoderSample(CCSTimeStamp time, double position) {
        this.time = time;
        this.position = position;
    }

    /**
     * Gets the time at which the position sample was taken..
     * @return the time value, a CCS timestamp.
     * */
    @Override
    public CCSTimeStamp getTime()
    {
        return time;
    }

    /**
     * Gets the sampled encoder position.
     * @return the position in mm.
     */
    public double getPosition()
    {
        return position;
    }

}
