/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.subsystem.shutter.common.RTD;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;

public final class ShutterStatus
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final int motionProfile;
    private final int isCalibrated;
    private final int smState;
    private final Map<ShutterSide, AxisStatus> axstatus;
    private final int isSafetyOn;
    private final Map<RTD, Double> temperature;
    private final Map<RTD, Integer> tempIsSafe;

    public ShutterStatus(int motionProfile, boolean isCalibrated, int smState, Map<ShutterSide, AxisStatus> axes, boolean isSafetyOn, Map<RTD, Double> temperature, Map<RTD, Boolean> tempIsSafe) {
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated ? 1 : 0;
        this.smState = smState;
        this.axstatus = new EnumMap<ShutterSide, AxisStatus>(axes);
        int n = this.isSafetyOn = isSafetyOn ? 1 : 0;
        if (temperature == null || temperature.size() != 3) {
            throw new IllegalArgumentException("Temperature map is null or has size != 3");
        }
        if (tempIsSafe == null || tempIsSafe.size() != 3) {
            throw new IllegalArgumentException("Temp-is-safe map is null or has size != 3");
        }
        this.temperature = new TreeMap<RTD, Double>(temperature);
        this.tempIsSafe = new TreeMap<RTD, Integer>();
        for (RTD rtd : RTD.values()) {
            this.tempIsSafe.put(rtd, tempIsSafe.get((Object)rtd) != false ? 1 : 0);
        }
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated == 1;
    }

    public int getSmState() {
        return this.smState;
    }

    public AxisStatus getAxisStatus(ShutterSide side) {
        return this.axstatus.get((Object)side);
    }

    public boolean isSafetyOn() {
        return this.isSafetyOn == 1;
    }

    public Map<RTD, Double> getTemperature() {
        return new TreeMap<RTD, Double>(this.temperature);
    }

    public Map<RTD, Boolean> getTempIsSafe() {
        TreeMap<RTD, Boolean> result = new TreeMap<RTD, Boolean>();
        for (RTD rtd : RTD.values()) {
            result.put(rtd, this.tempIsSafe.get((Object)rtd) == 1);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShutterStatus{motionProfile=").append(this.motionProfile);
        sb.append(", isCalibrated=").append(this.isCalibrated);
        sb.append(", smState=").append(this.smState);
        sb.append(", axstatus=").append(this.axstatus);
        sb.append(", isSafetyOn=").append(this.isSafetyOn);
        sb.append(", temperature=").append(this.temperature);
        sb.append(", tempIsSafe=").append(this.tempIsSafe);
        sb.append('}');
        return sb.toString();
    }

    public static final class AxisStatus
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private final double actPos;
        private final double actVel;
        private final double setAcc;
        private final int enabled;
        private final int brakeEngaged;
        private final int lowLimit;
        private final int highLimit;
        private final int isHomed;
        private final int errorID;
        private final double ctrlTemp;
        private final int hasSafeTemp;

        public AxisStatus(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeEngaged, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double ctrlTemp, boolean hasSafeTemp) {
            this.actPos = actPos;
            this.actVel = actVel;
            this.setAcc = setAcc;
            this.enabled = enabled ? 1 : 0;
            this.brakeEngaged = brakeEngaged ? 1 : 0;
            this.lowLimit = lowLimit ? 1 : 0;
            this.highLimit = highLimit ? 1 : 0;
            this.isHomed = isHomed ? 1 : 0;
            this.errorID = errorID;
            this.ctrlTemp = ctrlTemp;
            this.hasSafeTemp = hasSafeTemp ? 1 : 0;
        }

        public String toString() {
            return "AxisStatus{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeEngaged=" + this.brakeEngaged + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", ctrlTemp=" + this.ctrlTemp + ", hasSafeTemp=" + this.hasSafeTemp + '}';
        }

        public double getActPos() {
            return this.actPos;
        }

        public double getActVel() {
            return this.actVel;
        }

        public double getSetAcc() {
            return this.setAcc;
        }

        public boolean isEnabled() {
            return this.enabled == 1;
        }

        public boolean isBrakeEngaged() {
            return this.brakeEngaged == 1;
        }

        public boolean atLowLimit() {
            return this.lowLimit == 1;
        }

        public boolean atHighLimit() {
            return this.highLimit == 1;
        }

        public boolean isHomed() {
            return this.isHomed == 1;
        }

        public int getErrorID() {
            return this.errorID;
        }

        public double getCtrlTemp() {
            return this.ctrlTemp;
        }

        public boolean hasSafeTemp() {
            return this.hasSafeTemp == 1;
        }
    }
}

