package org.lsst.ccs.subsystem.shutter.common;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import static org.lsst.ccs.subsystem.shutter.common.ShutterSide.MINUSX;
import static org.lsst.ccs.subsystem.shutter.common.ShutterSide.PLUSX;

/**
 *
 * @author tether
 */
public class Constants {

    /**
     * The name which the worker subsystem will use on the status bus.
     */
    public static final String WORKER_SUBSYSTEM_NAME = "cam-shutter";

    /**
     * The furthest distance, in mm, that a blade set can get from its home position.
     */
    public static final double MAX_STROKE_LENGTH = 750.0;

    /**
     * The home positions, in mm, for each blade set. These are given in the encoder coordinates
     * for the each axis.
     * @see #INTERAXIS_OFFSET
     */
    public static final Map<ShutterSide, Double> BLADE_SET_HOME;
    static {
        Map<ShutterSide, Double> home = new EnumMap<>(ShutterSide.class);
        home.put(PLUSX, 0.0);
        home.put(MINUSX, MAX_STROKE_LENGTH);
        BLADE_SET_HOME = Collections.unmodifiableMap(home);
    }

    /** The offset in mm from the encoder coordinate origin for the +X blade set
        to that of the -X blade set. If both encoders give the same value
        then the blade sets are actually this far apart.
        */
    public static final double INTERAXIS_OFFSET = 97.0;

    /**
     * The path used to access the PhysicalState value in the state bundle
     * of status messages sent from the shutter worker subsystem.
     */
    public static String PHYSICAL_STATE_PATH = "statemachine";
    
    /**
     * The path used to access the SoftwareState value in the state bundle
     * of status messages sent from the shutter worker subsystem.
     */
    public static String SOFTWARE_STATE_PATH = "statemachine";

    private Constants() {} // Make the class non-instantiable.
}
