/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystems.shutter.common.BladeSet;
import org.lsst.ccs.subsystems.shutter.common.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.common.HallConfiguration;
import org.lsst.ccs.subsystems.shutter.common.ShutterConfiguration;
import org.lsst.ccs.subsystems.shutter.common.ShutterController;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.subsystems.shutter.sim.BladeSetSimulator;

public class SimController
extends ConfigurableComponent
implements ShutterController {
    private Map<ShutterSide, BladeSet> bladeSets = null;

    @Override
    public void init(Map<ShutterSide, BladeSetConfiguration> bsetConfigs, ShutterConfiguration shutterConfig, List<HallConfiguration> hallConfigs) {
        EnumMap<ShutterSide, BladeSetSimulator> bsets = new EnumMap<ShutterSide, BladeSetSimulator>(ShutterSide.class);
        for (ShutterSide side : ShutterSide.values()) {
            bsets.put(side, new BladeSetSimulator(side, bsetConfigs.get((Object)side), shutterConfig, hallConfigs));
        }
    }

    @Override
    public Map<ShutterSide, BladeSet> getBladeSets() {
        return this.bladeSets;
    }
}

