/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.BladeSet;
import org.lsst.ccs.subsystems.shutter.common.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.common.HallConfiguration;
import org.lsst.ccs.subsystems.shutter.common.MovementHistory;
import org.lsst.ccs.subsystems.shutter.common.ShutterConfiguration;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotorSimulator;

public final class BladeSetSimulator
implements BladeSet {
    private final ShutterSide side;
    private final BladeSetConfiguration config;
    private final ShutterConfiguration shutterConfig;
    private final List<HallConfiguration> hallConfigs;
    private volatile double position;

    public BladeSetSimulator(ShutterSide side, BladeSetConfiguration config, ShutterConfiguration shutterConfig, List<HallConfiguration> hallConfigs) {
        this.side = side;
        this.position = 0.0;
        this.config = config;
        this.shutterConfig = shutterConfig;
        this.hallConfigs = hallConfigs;
    }

    @Override
    public BladeSetConfiguration getBladeSetConfiguration() {
        return this.config;
    }

    @Override
    public double getRelativePosition() {
        return this.position;
    }

    @Override
    public ShutterSide getSide() {
        return this.side;
    }

    @Override
    public MovementHistory moveToPosition(double targetPosition, double moveTimeSeconds) {
        int numSamples = (int)(1L + Math.round(moveTimeSeconds / 0.05));
        double dt = moveTimeSeconds / (double)(numSamples - 1);
        double startPosition = this.getRelativePosition();
        long startTime = System.currentTimeMillis() * 1000L;
        CubicSCurve profile = new CubicSCurve(targetPosition - this.getRelativePosition(), moveTimeSeconds);
        MotorSimulator motor = new MotorSimulator(startPosition, dt, numSamples, startTime, profile);
        MotorEncoderSimulator encoder = new MotorEncoderSimulator();
        HallSensorSimulator hall = new HallSensorSimulator(startTime, startPosition, targetPosition, profile);
        List bladePos = motor.getPositions().map(encoder).collect(Collectors.toList());
        List hallTrans = hall.getTransitions().collect(Collectors.toList());
        long endTime = ((BladePosition)bladePos.get(bladePos.size() - 1)).getTime();
        this.position = targetPosition;
        return new MovementHistory(this.getSide(), 1, startTime, startPosition, endTime, targetPosition, Collections.unmodifiableList(bladePos), Collections.unmodifiableList(hallTrans));
    }

    @Override
    public double encoderToAbsolute(double encoderValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double absoluteToEncoder(double absolute) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double absoluteToRelative(double abs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double relativeToAbsolute(double rel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFullyRetracted() {
        return this.getRelativePosition() < 1.0E-4;
    }

    @Override
    public boolean isFullyExtended() {
        return Math.abs(1.0 - this.getRelativePosition()) < 1.0E-4;
    }
}

