/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystems.shutter.sim.MotorSimulator;

public class MotorSimulatorTest {
    public static final double MOVE_TIME = 1.0;
    public static final double DISTANCE = 1.0;
    public static final int NUM_SAMPLES = 41;
    public static final double DT = 0.025;
    private static final String FMT = "%+8.4f  %+8.4f  %+8.4f";
    private static final MotionProfile profile = new CubicSCurve(1.0, 1.0);

    private static String format(double a, double b, double c) {
        return String.format(FMT, a, b, c);
    }

    public static MotorSimulator standardMotorSimulator() {
        return new MotorSimulator(0.0, 0.025, 41, 0L, profile);
    }

    @Test
    public void checkSCurveMotion() {
        MotorSimulator sim = MotorSimulatorTest.standardMotorSimulator();
        sim.getPositions().forEach(pos -> {
            String motor = MotorSimulatorTest.format(pos.getPosition(), pos.getVelocity(), pos.getAcceleration());
            double t = (double)pos.getTime() / 1000000.0;
            String prof = MotorSimulatorTest.format(profile.distance(t), profile.velocity(t), profile.acceleration(t));
            Assert.assertEquals((Object)motor, (Object)prof);
        });
    }
}

