package org.lsst.ccs.subsystems.shutter.sim;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystems.shutter.common.BladeSet;
import org.lsst.ccs.subsystems.shutter.common.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.common.HallConfiguration;
import org.lsst.ccs.subsystems.shutter.common.ShutterConfiguration;
import org.lsst.ccs.subsystems.shutter.common.ShutterController;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.framework.ConfigurableComponent;

/**
 * Creates two BladeSetSimulator objects.
 * @author tether
 */
public class SimController extends ConfigurableComponent implements ShutterController {
    
    private Map<ShutterSide, BladeSet> bladeSets = null;
    
    /** {@inheritDoc} */
    @Override
    public void init(
        final Map<ShutterSide, BladeSetConfiguration> bsetConfigs,
        final ShutterConfiguration shutterConfig,
        final List<HallConfiguration> hallConfigs)
    {
        final Map<ShutterSide, BladeSet> bsets = new EnumMap<>(ShutterSide.class);
        for (ShutterSide side: ShutterSide.values()) {
            bsets.put(
                side,
                new BladeSetSimulator(side, bsetConfigs.get(side), shutterConfig, hallConfigs));
        }
    }
    
    /** {@inheritDoc} */
    @Override
    public Map<ShutterSide, BladeSet> getBladeSets() {return bladeSets;}
}
