package org.lsst.ccs.subsystems.shutter.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The interface to general shutter control functions for both real and simulated hardware.
 * @author tether
 */
public interface ShutterController {
    
    /** Performs any once-only initialization of the hardware and creates the two BladeSets.
     * @param bsetConfigs The blade set configurations.
     * @param shutterConfig General shutter configuration.
     * @param hallConfigs Hall sensor configurations.
     * @throws IOException if hardware problems occur.
     */
    void init(
        Map<ShutterSide, BladeSetConfiguration> bsetConfigs,
        ShutterConfiguration shutterConfig,
        List<HallConfiguration> hallConfigs) throws IOException;
    
    /**
     * Gets the blade sets created during the initialization.
     * @return A map of the BladeSets. Will be null if initialization failed.
     */
    Map<ShutterSide, BladeSet> getBladeSets();
    
}
