package org.lsst.ccs.subsystems.shutter.common;

import org.lsst.ccs.utilities.logging.Logger;

import java.util.List;
import java.util.Map;

/**
 * Lays out the interface to the source(s) of configuration data.
 * @author tether
 */
public interface ConfigurationService {
    /**
     * Gets configuration data for all Hall sensors.
     * @param log Used to log errors.
     * @return The list of Hall configurations, or null if any configuration was invalid.
     */
    public List<HallConfiguration> getHallConfigurations(final Logger log);
    
    /**
     * Gets the configuration data for each blade set of the shutter.
     * @param log Used to log errors.
     * @return A map from each side of the shutter to its blade set configuration, or
     * null if either configuration was invalid.
     */
    public Map<ShutterSide, BladeSetConfiguration> getBladeSetConfigurations(final Logger log);
    
    /**
     * Gets the general configuration data for the shutter subsystem
     * apart from the Hall and blade set data.
     * @param log Used to log errors.
     * @return The configuration object, or null if the configuration was invalid.
     */
    public ShutterConfiguration getShutterConfiguration(final Logger log);
}
