package org.lsst.ccs.subsystems.shutter.common;

import java.lang.reflect.Constructor;

/**
 ***************************************************************************
 **
 **  Contains low-level hardware information
 **  for one blade set. Immutable.
 **  <p>
 **  See <a href="https://confluence.slac.stanford.edu/x/FKnPD">this Confluence page</a>
 **  for descriptions of the configuration parameters.
 **  
 **  @see org.lsst.ccs.drivers.iocard
 **  @see org.lsst.ccs.drivers.parker
 **  @author tether
 **
 ***************************************************************************
 */
public final class BladeSetConfiguration {

    /**
     * Gets the constructor to be used when making an instance of this class using data from an external
     * source such as a text file. This will generally be a human-readable source, other wise we could have
     * used deserialization.
     *
     * @return A reference to a {@code Constructor<BladeSetConfiguration>}.
     */
    public static Constructor<BladeSetConfiguration> getConstructor() {
        try {
            return BladeSetConfiguration.class.getDeclaredConstructor(
                ShutterSide.class,
                String.class,
                int.class,
                int.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class,
                int.class,
                int.class,
                int.class,
                int.class
            );
        } catch (NoSuchMethodException exc) {
            // We've screwed up and let this code get out of sync with the constructor.
            throw new Error("Bug in class BladeSetConfiguration!", exc);
        }
    }

    private final ShutterSide side;
    private final String  controllerHost;
    private final int     controllerPort;
    private final int     axis;
    private final double  encoderCountsPerMm;
    private final double  encoderOffset;
    private final double  feedbackP;
    private final double  feedbackI;
    private final double  feedbackD;
    private final double  homePos;
    private final double  openPos;
    private final double  closedPos;
    private final double  lowestPos;
    private final double  highestPos;
    private final int     dioPortToController;
    private final int     dioLineToController;
    private final int     dioPortFromController;
    private final int     dioLineFromController;

    public BladeSetConfiguration(
        ShutterSide side,
        String controllerHost,
        int controllerPort,
        int axis,
        double encoderCountsPerMm,
        double encoderOffset,
        double feedbackP,
        double feedbackI,
        double feedbackD,
        double homePos,
        double openPos,
        double closedPos,
        double lowestPos,
        double highestPos,
        int dioPortToController,
        int dioLineToController,
        int dioPortFromController,
        int dioLineFromController
    )
    {
        this.side = side;
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.axis = axis;
        this.encoderCountsPerMm = encoderCountsPerMm;
        this.encoderOffset = encoderOffset;
        this.feedbackP = feedbackP;
        this.feedbackI = feedbackI;
        this.feedbackD = feedbackD;
        this.homePos = homePos;
        this.openPos = openPos;
        this.closedPos = closedPos;
        this.lowestPos = lowestPos;
        this.highestPos = highestPos;
        this.dioPortToController = dioPortToController;
        this.dioLineToController = dioLineToController;
        this.dioPortFromController = dioPortFromController;
        this.dioLineFromController = dioLineFromController;
    }

    public ShutterSide getSide() {
        return side;
    }

    public String getControllerHost() {
        return controllerHost;
    }

    public int getControllerPort() {
        return controllerPort;
    }

    public int getAxis() {
        return axis;
    }

    public double getEncoderCountsPerMm() {
        return encoderCountsPerMm;
    }

    public double getEncoderOffset() {
        return encoderOffset;
    }

    public double getFeedbackP() {
        return feedbackP;
    }

    public double getFeedbackI() {
        return feedbackI;
    }

    public double getFeedbackD() {
        return feedbackD;
    }

    public double getHomePos() {
        return homePos;
    }

    public double getOpenPos() {
        return openPos;
    }

    public double getClosedPos() {
        return closedPos;
    }

    public double getLowestPos() {
        return lowestPos;
    }

    public double getHighestPos() {
        return highestPos;
    }

    public int getDioPortToController() {
        return dioPortToController;
    }

    public int getDioLineToController() {
        return dioLineToController;
    }

    public int getDioPortFromController() {
        return dioPortFromController;
    }

    public int getDioLineFromController() {
        return dioLineFromController;
    }
}
