/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.actions.RefrigAction;
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.StickyCondition;
import org.lsst.ccs.subsystem.refrig.TrimHeaterControl;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalAlert;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class ThermalMain
extends Subsystem
implements HasLifecycle {
    private static final String THERMAL_LIMITS = "ThermalLimits";
    private static final int UPDATE_STATE_INTVL = 1000;
    private static final int TEMP_REPEAT_COUNT = 3;
    private static final List<Set<Integer>> validTrimHeaterSets = new ArrayList<Set<Integer>>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, TrimHeaterControl> tempControlMap = new HashMap<String, TrimHeaterControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private HeaterPsDevice heaterPs;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private volatile double coldTempLimit = 40.0;
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private volatile double coldTempLowLimit;
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private volatile double cryoTempLowLimit;
    private String[] coldTempChans;
    private String[] cryoTempChans;
    private static final Logger LOG;
    private Set<Integer> trimHeaterSet;
    private final TrimHeater[] trimHeaters = new TrimHeater[7];
    private final List<Channel> coldTemps = new ArrayList<Channel>();
    private final List<Channel> cryoTemps = new ArrayList<Channel>();
    private final ThermalState thermalState = new ThermalState();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private final List<StickyCondition> coldLowCondition = new ArrayList<StickyCondition>();
    private final List<StickyCondition> coldHighCondition = new ArrayList<StickyCondition>();
    private final List<StickyCondition> cryoLowCondition = new ArrayList<StickyCondition>();
    private boolean coldHigh = false;
    private boolean coldLow = false;
    private boolean cryoLow = false;
    private String refrigGroup = null;
    private MonitorTaskControl monitorControl;
    private boolean inited = false;

    public ThermalMain() {
        super("thermal", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("thermal-state", () -> this.updateThermalState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        Channel chan;
        this.propertiesService.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.refrigGroup = RefrigUtils.getGroupName((AgentInfo)this.getAgentInfo());
        HashSet<Integer> heaters = new HashSet<Integer>();
        for (TrimHeaterControl trimHeaterControl : this.tempControlMap.values()) {
            int htr = trimHeaterControl.getPowerChannel();
            heaters.add(htr);
            this.trimHeaters[htr] = new TrimHeater(trimHeaterControl, trimHeaterControl.getPowerDevice(), htr);
        }
        for (Set set : validTrimHeaterSets) {
            if (!set.equals(heaters)) continue;
            this.trimHeaterSet = set;
            break;
        }
        if (this.trimHeaterSet == null) {
            throw new RuntimeException("Trim heater loop set is not a valid one");
        }
        this.thermalState.setTrimHeaters(this.trimHeaterSet.toArray(this.thermalState.getTrimHeaters()));
        if (this.coldTempChans == null) {
            throw new RuntimeException("No center cold-plate temperature monitoring channels specified");
        }
        for (Iterator<Object> iterator : this.coldTempChans) {
            chan = this.allChannels.get(iterator);
            if (chan == null) {
                throw new RuntimeException("Parameter centerColdTempChans contains non-channel item: " + iterator);
            }
            this.coldTemps.add(chan);
        }
        for (Channel channel : this.coldTemps) {
            this.coldLowCondition.add(new StickyCondition(3));
            this.coldHighCondition.add(new StickyCondition(3));
        }
        if (this.cryoTempChans == null) {
            throw new RuntimeException("No cryo-plate temperature monitoring channels specified");
        }
        for (Iterator<Object> iterator : this.cryoTempChans) {
            chan = this.allChannels.get(iterator);
            if (chan == null) {
                throw new RuntimeException("Parameter cryoTempChans contains non-channel item: " + iterator);
            }
            this.cryoTemps.add(chan);
        }
        for (Channel channel : this.cryoTemps) {
            this.cryoLowCondition.add(new StickyCondition(3));
        }
        this.alertService.registerAlert(ThermalAlert.COLD_TEMP_HIGH.newAlert());
        this.alertService.registerAlert(ThermalAlert.COLD_TEMP_LOW.newAlert());
        this.alertService.registerAlert(ThermalAlert.CRYO_TEMP_LOW.newAlert());
    }

    public void postStart() {
        this.publishState();
        this.inited = true;
        LOG.info("Thermal control system started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state", level=0)
    public ThermalState getSystemState() {
        return this.thermalState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater operation state")
    public void setTrimHeaterState(int htr, TrimHeaterOpState state) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                TrimHeaterOpState oldState = this.thermalState.getTrimHeaterOpState(htr);
                if (state != oldState & this.thermalState.getTrimHeaterState(htr) != TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, state);
                    heater.tempCtrl.setOpState(state);
                    heater.inited = true;
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power set point")
    public void setTrimHeaterPower(int htr, double power) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setTrimHeaterPower(htr, power);
                heater.tempCtrl.setPower(power);
                heater.inited = true;
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a plate temperature set point")
    public void setPlateTemperature(int htr, double temp) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setPlateTemperature(htr, temp);
                heater.tempCtrl.setTemp(temp);
                heater.inited = true;
            }
            finally {
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off the bulk power supply")
    public void bulkPowerOn(boolean on) {
        this.heaterPs.setBulkPowerOn(on);
        this.publishState();
    }

    private void publishState() {
        this.thermalState.setTickMillis(this.monitorControl.getFastPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.thermalState));
    }

    private void checkTempLimits() {
        int j;
        boolean coldHigh = false;
        boolean coldLow = false;
        boolean cryoLow = false;
        for (j = 0; j < this.coldTemps.size(); ++j) {
            Channel channel;
            coldHigh |= this.coldHighCondition.get(j).update((channel = this.coldTemps.get(j)).getValue() > this.coldTempLimit);
            coldLow |= this.coldLowCondition.get(j).update(channel.getValue() < this.coldTempLowLimit);
        }
        for (j = 0; j < this.cryoTemps.size(); ++j) {
            cryoLow |= this.cryoLowCondition.get(j).update(this.cryoTemps.get(j).getValue() < this.cryoTempLowLimit);
        }
        if (coldHigh != this.coldHigh) {
            if (coldHigh) {
                this.raiseAlert(ThermalAlert.COLD_TEMP_HIGH, AlertState.ALARM, "At least one cold-plate RTD is above " + this.coldTempLimit + " C", null);
            } else {
                this.lowerAlert(ThermalAlert.COLD_TEMP_HIGH, "No cold-plate RTD is above " + this.coldTempLimit + " C", null);
            }
            this.coldHigh = coldHigh;
        }
        if (coldLow != this.coldLow) {
            if (coldLow) {
                this.raiseAlert(ThermalAlert.COLD_TEMP_LOW, AlertState.ALARM, "At least one cold-plate RTD is below " + this.coldTempLowLimit + " C", RefrigAction.Action.COLD_PLATE_TOO_COLD);
            } else {
                this.lowerAlert(ThermalAlert.COLD_TEMP_LOW, "No cold-plate RTD is below " + this.coldTempLowLimit + " C", RefrigAction.Action.COLD_PLATE_TOO_COLD);
            }
            this.coldLow = coldLow;
        }
        if (cryoLow != this.cryoLow) {
            if (cryoLow) {
                this.raiseAlert(ThermalAlert.CRYO_TEMP_LOW, AlertState.ALARM, "At least one cryo-plate RTD is below " + this.cryoTempLowLimit + " C", RefrigAction.Action.CRYO_PLATE_TOO_COLD);
            } else {
                this.lowerAlert(ThermalAlert.CRYO_TEMP_LOW, "No cryo-plate RTD is below " + this.cryoTempLowLimit + " C", RefrigAction.Action.CRYO_PLATE_TOO_COLD);
            }
            this.cryoLow = cryoLow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThermalState() {
        this.checkTempLimits();
        if (!this.inited) {
            return;
        }
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            SwitchState bulkPowerState;
            boolean changed = this.monitorControl.hasPeriodChanged();
            for (int htr : this.trimHeaterSet) {
                TrimHeaterState oldState;
                TrimHeater heater = this.trimHeaters[htr];
                TrimHeaterState state = this.coldHigh && htr != 0 ? TrimHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (heater.tempCtrl.isOverTemp() ? TrimHeaterState.OVRTEMP : (!heater.powerDevc.isEnabled(heater.powerChan) ? TrimHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? TrimHeaterState.VOLTERR : (heater.powerDevc.hasNoLoad(heater.powerChan) ? TrimHeaterState.NOLOAD : (this.thermalState.getTrimHeaterOpState(htr) == TrimHeaterOpState.TEMP ? TrimHeaterState.TEMP : TrimHeaterState.POWER))))));
                if (state == (oldState = this.thermalState.getTrimHeaterState(htr))) continue;
                this.thermalState.setTrimHeaterState(htr, state);
                if (oldState == TrimHeaterState.OFFLINE) {
                    if (!heater.inited) {
                        if (heater.powerDevc.isEnabled(heater.powerChan)) {
                            double power = heater.powerDevc.getPower(heater.powerChan);
                            this.thermalState.setTrimHeaterPower(htr, power);
                            heater.tempCtrl.setPower(power);
                            this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.POWER);
                            heater.tempCtrl.setOpState(TrimHeaterOpState.POWER);
                        } else {
                            this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.OFF);
                            heater.tempCtrl.setOpState(TrimHeaterOpState.OFF);
                        }
                        heater.inited = true;
                    } else {
                        heater.tempCtrl.setPower(this.thermalState.getTrimHeaterPower(htr));
                        heater.tempCtrl.setTemp(this.thermalState.getPlateTemperature(htr));
                        heater.tempCtrl.setOpState(this.thermalState.getTrimHeaterOpState(htr));
                    }
                }
                if (state == TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.OFF);
                    heater.tempCtrl.setOpState(TrimHeaterOpState.OFF);
                }
                changed = true;
            }
            Boolean bulkOn = this.heaterPs.isBulkPowerOn();
            SwitchState switchState = bulkOn == null ? SwitchState.OFFLINE : (bulkPowerState = bulkOn != false ? SwitchState.ON : SwitchState.OFF);
            if (bulkPowerState != this.thermalState.getBulkPowerState()) {
                this.thermalState.setBulkPowerState(bulkPowerState);
                changed = true;
            }
            if (changed) {
                this.publishState();
            }
        }
    }

    private void raiseAlert(ThermalAlert alert, AlertState state, String cond, RefrigAction.Action action) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), true);
        if (wasActive != Boolean.TRUE) {
            Alert al = alert.newAlert();
            if (action != null) {
                RefrigAction.addData((Alert)al, (RefrigAction.Action)action);
            }
            this.alertService.raiseAlert(al, state, cond);
        }
    }

    private void lowerAlert(ThermalAlert alert, String cond, RefrigAction.Action action) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), false);
        if (wasActive == Boolean.TRUE) {
            Alert al = alert.newAlert();
            if (action != null) {
                RefrigAction.addData((Alert)al, (RefrigAction.Action)action);
            }
            this.alertService.raiseAlert(al, AlertState.NOMINAL, cond);
        }
    }

    private TrimHeater getTrimHeater(int htr) throws RefrigException {
        if (!this.trimHeaterSet.contains(htr)) {
            throw new RefrigException("Invalid trim heater number: " + htr);
        }
        return this.trimHeaters[htr];
    }

    static {
        LinkedHashSet<Integer> trimSet = new LinkedHashSet<Integer>();
        trimSet.add(1);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(4);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(6);
        trimSet.add(5);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        LOG = Logger.getLogger(ThermalMain.class.getName());
    }

    static class TrimHeater {
        TrimHeaterControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;
        boolean inited = false;

        TrimHeater(TrimHeaterControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

