/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class HeaterPIControl
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, PowerDevice> powerDevices = new HashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput;
    private Double awGain;
    private Double basePower;
    private Double tolerance;
    private double minOutput = 0.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String powerDevc;
    private Integer powerChan;
    private String[] tempChans;
    @ConfigurationParameter(category="Refrig")
    private final Map<String, Double> tempWeights = new HashMap<String, Double>();
    private static final Logger LOG = Logger.getLogger(HeaterPIControl.class.getName());
    private PIController pic;
    private PowerDevice powerDevcC;
    private final Map<String, ChannelData> channelData = new HashMap<String, ChannelData>();
    private double lastPower;
    private boolean active;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask(this.name + "-timer", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(this.updateTime.intValue()));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        if (this.gain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.maxOutput == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maxOutput", (String)"is missing");
        }
        if (this.awGain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.basePower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"basePower", (String)"is missing");
        }
        if (this.tolerance == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        if (this.powerDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerDevc", (String)"is missing");
        }
        this.powerDevcC = this.powerDevices.get(this.powerDevc);
        if (this.powerDevcC == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)this.powerDevc, (String)"doesn't exist");
        }
        if (this.powerChan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerChan", (String)"is missing");
        }
        this.checkTempWeights(this.tempWeights);
        if (this.tempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)"is missing");
        }
        for (String cName : this.tempChans) {
            Double value;
            Channel chan = this.allChannels.get(cName);
            if (chan == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)("element " + cName + " doesn't exist"));
            }
            ChannelData cData = new ChannelData();
            this.channelData.put(cName, cData);
            cData.channel = chan;
            cData.weight = this.tempWeights.isEmpty() ? 1.0 : ((value = this.tempWeights.get(cName)) == null ? 0.0 : value);
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.basePower.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    @ConfigurationParameterChanger
    public void setTempWeights(Map<String, Double> weights) {
        if (!this.channelData.isEmpty()) {
            this.checkTempWeights(weights);
            for (ChannelData channelData : this.channelData.values()) {
                channelData.weight = weights.isEmpty() ? 1.0 : 0.0;
            }
            for (Map.Entry entry : weights.entrySet()) {
                ChannelData cData = this.channelData.get((String)entry.getKey());
                if (cData == null) continue;
                cData.weight = (Double)entry.getValue();
            }
        }
        this.tempWeights.clear();
        this.tempWeights.putAll(weights);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a temperature weight")
    public void setTempWeight(@Argument(description="Channel name") String cName, @Argument(description="Channel weight") double weight) throws RefrigException {
        HashMap<String, Double> weights = new HashMap<String, Double>();
        weights.putAll(this.tempWeights);
        weights.put(cName, weight);
        this.configService.change(this.name, "tempWeights", weights);
    }

    public PowerDevice getPowerDevice() {
        return this.powerDevcC;
    }

    public int getPowerChannel() {
        return this.powerChan;
    }

    public void setTemp(double value) {
        this.pic.setSetpoint(value);
    }

    public void reset() {
        this.pic.reset();
    }

    public void restart() {
        this.start(this.lastPower);
    }

    public synchronized void start(double power) {
        if (this.active) {
            return;
        }
        this.active = true;
        this.pic.reset();
        this.pic.setIntegral(power - this.basePower);
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    private synchronized void iterateLoop() {
        if (!this.active) {
            return;
        }
        double temp = 0.0;
        double weight = 0.0;
        for (ChannelData cData : this.channelData.values()) {
            double value = cData.channel.getValue();
            if (Double.isNaN(value)) continue;
            temp += cData.weight * value;
            weight += cData.weight;
        }
        if (weight > 0.0) {
            double avgTemp = temp / weight;
            LOG.log(Level.FINE, "{0} control loop average temperature = {1}", new Object[]{this.name, avgTemp});
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastPower = this.pic.performPI(new double[]{avgTemp}, tod);
            this.powerDevcC.setPower(this.powerChan, this.lastPower);
        } else {
            LOG.log(Level.SEVERE, "{0} control loop iteration failed: no valid temperatures available", this.name);
        }
    }

    private void checkTempWeights(Map<String, Double> weights) {
        for (Map.Entry<String, Double> entry : weights.entrySet()) {
            String cName = entry.getKey();
            if (this.allChannels.get(cName) == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempWeights", (String)("element " + cName + " doesn't exist"));
            }
            if (!(entry.getValue() < 0.0)) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempWeights", (String)("element " + cName + " has negative value"));
        }
    }

    static class ChannelData {
        Channel channel;
        double weight;

        ChannelData() {
        }
    }
}

