package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Controls a simulated PCP power supply.
 *
 *  @author Owen Saxton
 */
public class SimPcpPowerControl extends PcpPowerControl {

    private static final double[] loads = new double[PcpPowerDevice.NUM_CHANS];
    static {
        loads[PcpPowerDevice.CHAN_MINUS_Y] = 10.0;
        loads[PcpPowerDevice.CHAN_CENTER] = 2.5;
        loads[PcpPowerDevice.CHAN_PLUS_Y] = 10.0;
    }
    private double voltage;


    /**
     *  Sets a voltage.
     *
     *  @param  value  The value
     *  @throws  DriverException
     */
    @Override
    public void setVoltage(double value) throws DriverException
    {
        super.setVoltage(value);
        ChannelDesc chanDesc = channelDescs[CHAN_IN_VOLTAGE];
        maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, chanDesc.scale * value);
        chanDesc = channelDescs[CHAN_IN_CURRENT];
        maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, chanDesc.scale * value / loads[ident]);
        voltage = value;
    }


    /**
     *  Sets a simulated output state.
     *
     *  @param  value  The value
     *  @throws  DriverException
     */
    public void setOutput(boolean value) throws DriverException
    {
        ChannelDesc chanDesc = channelDescs[CHAN_IN_ENABLED];
        maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, value ? 0.0 : 5.0);
        setVoltage(value ? voltage : 0.0);
    }

}
