package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

/**
 * A derived channel to calculate enthalpy exchange
 * 
 * @author The LSST CCS Team
 */
public class EnthalpyExchangeChannel extends DerivedChannel {
    
    private Channel supplyTempChannel;
    private Channel preExpnTempChannel;
    private double r507aSpecHeat = 1.43;
    
    @Override
    public void build()
    {        
        if (supplyTempChannel == null) {
            throw new RuntimeException(getName() + " parameter error: supplyTempChannel has not been defined");
        }
        if (preExpnTempChannel == null) {
            throw new RuntimeException(getName() + " parameter error : preExpnTempChannel has not been defined");
        }
        super.build();
    }

    @Override
    public double evaluateDerivedValue()
    {
        return r507aSpecHeat * (supplyTempChannel.getValue() - preExpnTempChannel.getValue());
    }
    
}
