/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusLockAggregate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AbstractAgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class RemoteAgentLockService
extends AbstractAgentLockServiceDelegate {
    private AgentMessagingLayer aml;
    private ConcurrentMessagingUtils cmu;
    StatusMessageListener sml = msg -> {
        log.fine((Object)("message " + msg + " object " + msg.getObject()));
        if (!(msg instanceof StatusLock || msg instanceof StatusLockAggregate || msg instanceof StatusStateChangeNotification)) {
            return;
        }
        if (msg instanceof StatusStateChangeNotification) {
            String agentName;
            StatusStateChangeNotification ssnc = (StatusStateChangeNotification)msg;
            if (ssnc.getState().isInState((Enum)OperationalState.NORMAL) && ssnc.getState().isInState((Enum)CommandState.READY) && this.heldLocks.get(agentName = ssnc.getOriginAgentInfo().getName()) != null && this.getLevelForAgent(agentName) > 0) {
                try {
                    System.out.println("level set to 0");
                    log.info((Object)(agentName + " went to NORMAL mode, lock level set to 0"));
                    this.setLevelInternal(agentName, 0);
                }
                catch (UnauthorizedLevelException unauthorizedLevelException) {
                    // empty catch block
                }
            }
            return;
        }
        Serializable obj = msg.getObject();
        String source = msg.getOriginAgentInfo().getName();
        if (obj instanceof AgentLockInfo) {
            this.handleLockInfo(source, (AgentLockInfo)obj);
        } else if (obj instanceof AgentLockInfo[]) {
            AgentLockInfo[] ll;
            for (AgentLockInfo l : ll = (AgentLockInfo[])obj) {
                this.handleLockInfo(source, l);
            }
        }
    };

    public RemoteAgentLockService(AgentLockService svc) {
        super(svc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLockInfo(String source, AgentLockInfo lock) {
        log.debug((Object)("got lock message from " + source + " : " + lock));
        boolean fromLM = "lockmanager".equals(source);
        boolean lockingMe = lock.getAgentName().equals(this.getAgent().getName());
        if (lock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED || lock.getStatus() == AgentLockInfo.Status.REMINDER || lock.getStatus() == AgentLockInfo.Status.INFO || lock.getStatus() == AgentLockInfo.Status.ACK_LEGACY) {
            this.allLocks.put(lock.getAgentName(), lock);
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        } else if (lock.getStatus() == AgentLockInfo.Status.ATTACH || lock.getStatus() == AgentLockInfo.Status.DETACH) {
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        } else if (lock.getStatus() == AgentLockInfo.Status.RELEASED) {
            this.allLocks.remove(lock.getAgentName());
            if (this.heldLocks.get(lock.getAgentName()) != null) {
                log.info((Object)("Release lock on " + lock.getAgentName()));
            }
            try {
                this.removeHeldLock(lock.getAgentName(), (AgentLock)lock);
            }
            catch (UnauthorizedLockException unauthorizedLockException) {
                // empty catch block
            }
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        }
        if (lock.getStatus() == AgentLockInfo.Status.RELEASED && lockingMe && fromLM) {
            log.debug((Object)"releasing current lock");
            this.removeCurrentLock();
        } else if (lock.getStatus() == AgentLockInfo.Status.REQUESTED && fromLM && lockingMe) {
            log.debug((Object)("got request " + lock));
            AgentLockInfo reply = null;
            Object object = this.listenerUpdatesLock;
            synchronized (object) {
                AgentLock oldLock = this.getLockForAgent(this.getAgent().getName());
                if (oldLock != null && !oldLock.getOwner().equals(lock.getOwner())) {
                    reply = AgentLockInfo.createReject((AgentLockInfo)lock);
                    log.warn((Object)("Rejecting invalid lock request " + reply));
                } else {
                    reply = AgentLockInfo.createAcknowledge((AgentLockInfo)lock);
                    log.debug((Object)("ack " + reply));
                    this.setCurrentLock((AgentLock)reply);
                }
            }
            StatusLock replyMsg = new StatusLock(reply);
            this.aml.sendStatusMessage((StatusMessage)replyMsg);
        } else if (lock.getStatus() == AgentLockInfo.Status.REMINDER && fromLM && lockingMe) {
            if (lock.getAgentName().equals(this.getAgent().getName())) {
                log.info((Object)("got reminder " + lock));
                if (this.getCurrentLock() != null && !this.getCurrentLock().getToken().equals(lock.getToken())) {
                    log.warn((Object)("lock reminder but we are locked: " + this.getCurrentLock()));
                } else if (this.getCurrentLock() == null) {
                    this.setCurrentLock((AgentLock)lock);
                }
            }
        } else if ((lock.getStatus() == AgentLockInfo.Status.ATTACH || lock.getStatus() == AgentLockInfo.Status.DETACH) && fromLM && lockingMe) {
            this.notifyLockListeners(lock.getAgentName(), lock.getOwner(), (AgentLock)lock);
        }
    }

    @Override
    public void preInit() {
        super.preInit();
        this.aml = this.getAgent().getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.aml);
        this.getAgent().getAgentInfo().getAgentProperties().setProperty("lockable", "true");
    }

    @Override
    public void preStart() {
        log.finest((Object)"adding lock message listener");
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class).or(BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo[].class)).or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class)));
    }

    @Override
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException {
        AgentLockInfo lock = null;
        lock = (AgentLockInfo)this.heldLocks.get(agentName);
        if (lock == null) {
            try {
                if ("lockmanager".equals(agentName)) {
                    throw new UnauthorizedLockException("The lock manager subsystem cannot be locked");
                }
                AgentLockInfo request = AgentLockInfo.createLockRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
                lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "lockOrAttach", new Object[]{request}));
                if (lock != null) {
                    this.addHeldLock((AgentLock)lock);
                }
            }
            catch (RuntimeException | UnauthorizedLevelException | UnauthorizedLockException e) {
                throw e;
            }
            catch (CommandRejectedException e) {
                throw new UnauthorizedLockException(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (lock == null) {
                throw new UnauthorizedLevelException("Unable to lock " + agentName + ", cannot set level");
            }
            if (!this.svc.getUserId().equals(lock.getOwner())) {
                throw new UnauthorizedLevelException("Unable to lock " + agentName + ", locked by " + lock.getOwner() + " cannot set level");
            }
            if (level > lock.getMaxLevel()) {
                throw new UnauthorizedLevelException("User '" + lock.getOwner() + "' is not allowed to set level above '" + lock.getMaxLevel() + "' for subsystem '" + agentName + "'");
            }
            this.setLevelInternal(agentName, level);
        }
        if (lock == null || !this.svc.getUserId().equals(lock.getOwner())) {
            throw new UnauthorizedLevelException("Unable to lock " + agentName + ", cannot set level");
        }
        if (level > lock.getMaxLevel()) {
            throw new UnauthorizedLevelException("User '" + lock.getOwner() + "' is not allowed to set level above '" + lock.getMaxLevel() + "' for subsystem '" + agentName + "'");
        }
        this.setLevelInternal(agentName, level);
    }

    @Override
    public void attachLock(String agentName) throws UnauthorizedLockException {
        try {
            AgentLockInfo request = AgentLockInfo.createAttachRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "attachLock", new Object[]{request}));
            log.info((Object)("received lock for attach " + lock));
            this.addHeldLock((AgentLock)lock);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (CommandRejectedException e) {
            throw new UnauthorizedLockException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void detachLock(String agentName) throws UnauthorizedLockException {
        try {
            AgentLock oldLock = this.getHeldLocks().get(agentName);
            if (oldLock == null || !oldLock.getOwner().equals(this.svc.getUserId())) {
                throw new UnauthorizedLevelException("no lock is held to detach");
            }
            AgentLockInfo request = AgentLockInfo.createDetach((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            this.cmu.sendAsynchronousCommand(new CommandRequest("lockmanager", "detachLock", new Object[]{request}));
            this.removeHeldLock(agentName, (AgentLock)request);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void lockAgent(String agentName) throws UnauthorizedLockException {
        try {
            if ("lockmanager".equals(agentName)) {
                throw new UnauthorizedLockException("cannot lock the lock manager");
            }
            AgentLockInfo request = AgentLockInfo.createLockRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "lockAgent", new Object[]{request}));
            log.info((Object)("received lock " + lock));
            if (lock == null) {
                throw new UnauthorizedLockException("could not lock " + agentName);
            }
            this.addHeldLock((AgentLock)lock);
            this.allLocks.put(agentName, lock);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (CommandRejectedException e) {
            throw new UnauthorizedLockException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unlockAgent(String agentName) throws UnauthorizedLockException {
        AgentLock oldLock = this.getExistingLockForAgent(agentName);
        if (oldLock == null) {
            return;
        }
        if (!oldLock.getOwner().equals(this.svc.getUserId())) {
            throw new UnauthorizedLockException("Subsystem " + agentName + " is locked by " + oldLock.getOwner() + ", you are logged in as " + this.svc.getUserId() + ". Cannot unlock.");
        }
        AgentLockInfo request = AgentLockInfo.createRelease((String)agentName, (String)this.svc.getUserId());
        this.cmu.sendAsynchronousCommand(new CommandRequest("lockmanager", "unlockAgent", new Object[]{request}));
        this.removeHeldLock(agentName, (AgentLock)request);
    }

    @Override
    public void destroyLock(String agentName, String userId) {
        try {
            this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "destroyLock", new Object[]{agentName, userId}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

