package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

/**
 * A Derived channel to calculate superheat
 * 
 * @author The LSST CCS Team
 */
public class SuperHeatChannel extends DerivedChannel {
    
    private Channel evapExitTempChannel;
    private Channel returnPressureChannel;
    
    @LookupField(strategy = LookupField.Strategy.TOP)
    private HexMain hex;
    
    @Override
    public void build() {
        
        if ( evapExitTempChannel == null || returnPressureChannel == null ) {
            throw new RuntimeException("Both evapExitTemp and returnPressure channels must be defined and not null. "+evapExitTempChannel+" "+returnPressureChannel);
        }
        super.build(); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public double evaluateDerivedValue() {
        double pRead = returnPressureChannel.getValue();
        double tRead = evapExitTempChannel.getValue();
        if ( Double.isNaN(pRead) || Double.isNaN(tRead) ) {
            return Double.NaN;
        }
        
        pRead = pRead + hex.getRtnToEvapOffset();
        double result = tRead - PressureTemperatureUtils.evaluateSaturationTemperature(pRead);
        return result;

    }

    
}
