/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.logging.Level;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.lsst.ccs.localdb.statusdb.SlowBatchPersister;
import org.lsst.ccs.localdb.statusdb.model.StatData;

public class StatDataPersister
extends SlowBatchPersister<StatData> {
    @Override
    public void persist(StatData statData, Session sess) {
        sess.lock((Object)statData.getStatDesc(), LockMode.NONE);
        sess.lock((Object)statData.getStatTimeInterval(), LockMode.NONE);
        if (statData.getId() > 0L) {
            this.log.log(Level.FINEST, "merging : {0} and timebinwidth {1} starting at {2}", new Object[]{statData.getStatDesc().getDataDesc().getDataPath().getFullKey(), statData.getStatDesc().getTimeBinWidth(), statData.getStatTimeInterval().getStartTime()});
            sess.update((Object)statData);
        } else {
            this.log.log(Level.FINEST, "persisting stat data {0} and timebinwidth {1} starting at {2}", new Object[]{statData.getStatDesc().getDataDesc().getDataPath().getFullKey(), statData.getStatDesc().getTimeBinWidth(), statData.getStatTimeInterval().getStartTime()});
            sess.persist((Object)statData);
        }
    }

    public void flush(Session sess) {
        StatData sd = (StatData)this.rq.poll();
        while (sd != null) {
            this.persist(sd, sess);
            sd = (StatData)this.rq.poll();
        }
    }
}

