package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.command.annotations.Command;

/**
 *  Provides simulation functions for the heater PS
 *
 *  @author saxton
 */
public class SimHeaterPsDevice extends HeaterPsDevice {

    private boolean offline = false;


    /**
     *  Performs full initialization.
     */
    @Override
    protected void initialize()
    {
        if (!offline) {
            super.initialize();
        }
    }


    /**
     *  Command to set the device offline.
     *
     *  Used for testing behavior when it comes back online.
     */
    @Command(type=Command.CommandType.ACTION, description="Set device offline")
    public void setOffline()
    {
        offline = true;
        setOnline(false);
    }


    /**
     *  Command to clear the offline state.
     *
     *  Used for testing behavior when it comes back online.
     */
    @Command(type=Command.CommandType.ACTION, description="Clear device offline")
    public void clearOffline()
    {
        offline = false;
    }
    
}
