/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;

@SkipEncoding
public class ThermalState
implements Serializable {
    public static final String KEY = "ThermalState";
    private int tickMillis;
    private Integer[] trimHeaters = new Integer[0];
    private SwitchState bulkPowerState = SwitchState.OFFLINE;
    private final TrimHeaterOpState[] trimHeaterOpState = new TrimHeaterOpState[7];
    private final TrimHeaterState[] trimHeaterState = new TrimHeaterState[7];
    private final double[] trimHeaterPower = new double[7];
    private final double[] plateTemperature = new double[7];
    private static final long serialVersionUID = 5207828928167279057L;

    public ThermalState() {
        Arrays.fill((Object[])this.trimHeaterOpState, (Object)TrimHeaterOpState.OFF);
        Arrays.fill((Object[])this.trimHeaterState, (Object)TrimHeaterState.OFFLINE);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setTrimHeaters(Integer[] value) {
        this.trimHeaters = value;
    }

    public Integer[] getTrimHeaters() {
        return this.trimHeaters;
    }

    public void setBulkPowerState(SwitchState state) {
        this.bulkPowerState = state;
    }

    public SwitchState getBulkPowerState() {
        return this.bulkPowerState;
    }

    public void setTrimHeaterOpState(int heater, TrimHeaterOpState state) {
        this.trimHeaterOpState[heater] = state;
    }

    public TrimHeaterOpState getTrimHeaterOpState(int heater) {
        return this.trimHeaterOpState[heater];
    }

    public void setTrimHeaterState(int heater, TrimHeaterState state) {
        this.trimHeaterState[heater] = state;
    }

    public TrimHeaterState getTrimHeaterState(int heater) {
        return this.trimHeaterState[heater];
    }

    public void setTrimHeaterPower(int heater, double value) {
        this.trimHeaterPower[heater] = value;
    }

    public double getTrimHeaterPower(int heater) {
        return this.trimHeaterPower[heater];
    }

    public void setPlateTemperature(int heater, double value) {
        this.plateTemperature[heater] = value;
    }

    public double getPlateTemperature(int heater) {
        return this.plateTemperature[heater];
    }
}

