/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class PowerSupply {
    public static final int VOLTAGE_MODE = 0;
    public static final int CURRENT_MODE = 1;
    private Socket sock = null;
    private PrintWriter sock_write = null;
    private BufferedReader sock_read = null;
    private String channel = null;
    private int mode = 0;
    private static final int DEFAULT_PORT = 5025;

    public PowerSupply(String hostname, int chan) {
        this(hostname, chan, 5025);
    }

    public PowerSupply(String hostname, int chan, int port) {
        this.channel = Integer.toString(chan);
        try {
            this.sock = new Socket(hostname, port);
            this.sock_write = new PrintWriter(this.sock.getOutputStream(), true);
            this.sock_read = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("*** Unknown host " + hostname + "***");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("*** IOException thrown: " + e + " ***");
            System.exit(1);
        }
    }

    private int write(String instr) {
        this.sock_write.println(instr + "(@" + this.channel + ")");
        return 0;
    }

    private double read() {
        String str = "";
        double ret = 0.0;
        try {
            str = this.sock_read.readLine();
            ret = Double.parseDouble(str);
        }
        catch (IOException e) {
            ret = -1.0;
        }
        return ret;
    }

    public void on() {
        this.write("OUTP ON, ");
    }

    public void delayOn(double time) {
        this.write("OUTP:DEL:RISE " + Double.toString(time) + ",");
    }

    public void off() {
        this.write("OUTP OFF, ");
    }

    public void delayOff(double time) {
        this.write("OUTP:DEL:FALL" + Double.toString(time) + ",");
    }

    public void mode(int vctype) {
        if (vctype == 1) {
            this.write("FUNC CURR,");
        } else if (vctype == 0) {
            this.write("FUNC VOLT,");
        }
        this.mode = vctype;
    }

    public void slew(double rate) {
        if (this.mode == 0) {
            this.write("VOLT:SLEW " + Double.toString(rate) + ",");
        } else if (this.mode == 1) {
            this.write("CURR:SLEW " + Double.toString(rate) + ",");
        }
    }

    public void currentLimit(double maxima) {
        this.write("CURR:LIM " + Double.toString(maxima) + ",");
    }

    public void voltageLimit(double maxima) {
        this.write("VOLT:LIM " + Double.toString(maxima) + ",");
    }

    public double getVoltage() {
        this.write("MEAS:VOLT? ");
        return this.read();
    }

    public void setVoltage(double value) {
        this.write("VOLT " + Double.toString(value) + ", ");
    }

    public double getCurrent() {
        this.write("MEAS:CURR? ");
        return this.read();
    }

    public void setCurrent(double value) {
        this.write("CURR " + Double.toString(value) + ", ");
    }

    public void outputEnable(boolean val) {
        if (val) {
            this.on();
        } else {
            this.off();
        }
    }
}

