package org.lsst.ccs.subsystem.refrig;

/**
 *  Class to manage a boolean condition that requires repeated new values to change it.
 *
 *  @author saxton
 */
public class StickyCondition {

    final int minRepeatCount;
    boolean condition = false;
    int repeatCount = 0;

    StickyCondition(int minRepeatCount)
    {
        this.minRepeatCount = minRepeatCount;
    }

    /**
     *  Updates the condition.
     * 
     *  @param  newCond  The new condition value
     *  @return  The updated condition value
     */
    public boolean update(boolean newCond)
    {
        if (newCond != condition) {
            if (++repeatCount >= minRepeatCount) {
                condition = newCond;
                repeatCount = 0;
            }
        }
        else {
            repeatCount = 0;
        }
        return condition;
    }

}

