package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

/**
 *  Handles PcpPowerDevice child.
 *
 *  @author Owen Saxton
 */
public class PcpMaq20Device extends Maq20Device {

    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    private PcpPowerDevice powerDevc;

    /**
     *  Closes the connection.
     */
    @Override
    protected void close()
    {
        super.close();
        if (powerDevc != null) {
            powerDevc.setOnline(false);
        }
    }

}
