/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TrimHeaterControl;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalAlert;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class ThermalMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    private static final String THERMAL_LIMITS = "ThermalLimits";
    private static final int UPDATE_STATE_INTVL = 1000;
    private static final List<Set<Integer>> validTrimHeaterSets = new ArrayList<Set<Integer>>();
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, TrimHeaterControl> tempControlMap = new HashMap<String, TrimHeaterControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private HeaterPsDevice heaterPs;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private volatile double coldTempLimit = 40.0;
    private String[] coldTempNames;
    private static final Logger LOG;
    private Set<Integer> trimHeaterSet;
    private final TrimHeater[] trimHeaters = new TrimHeater[7];
    private final List<Channel> coldTemps = new ArrayList<Channel>();
    private final ThermalState thermalState = new ThermalState();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private int highTempCount = 0;
    private ColdState refrigColdState = ColdState.UNKNOWN;
    private String refrigGroup = null;
    private MonitorTaskControl monitorControl;
    private boolean inited = false;

    public ThermalMain() {
        super("thermal", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("thermal-state", () -> this.updateThermalState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.refrigGroup = RefrigUtils.getGroupName((AgentInfo)this.subsys.getAgentInfo());
        HashSet<Integer> heaters = new HashSet<Integer>();
        for (TrimHeaterControl trimHeaterControl : this.tempControlMap.values()) {
            int htr = trimHeaterControl.getPowerChannel();
            heaters.add(htr);
            this.trimHeaters[htr] = new TrimHeater(trimHeaterControl, trimHeaterControl.getPowerDevice(), htr);
        }
        for (Set set : validTrimHeaterSets) {
            if (!set.equals(heaters)) continue;
            this.trimHeaterSet = set;
            break;
        }
        if (this.trimHeaterSet == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"trim heater loop set", (String)"is not a valid one");
        }
        this.thermalState.setTrimHeaters(this.trimHeaterSet.toArray(this.thermalState.getTrimHeaters()));
        if (this.coldTempNames == null) {
            LOG.severe("No cold-plate temperature monitoring channels specified");
        } else {
            for (Iterator<Object> iterator : this.coldTempNames) {
                Channel chan = this.allChannels.get(iterator);
                if (chan == null) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"coldTempNames", (String)"contains non-channel item");
                }
                this.coldTemps.add(chan);
            }
        }
        this.alertService.registerAlert(ThermalAlert.COLD_TEMP_HIGH.newAlert());
        this.alertService.registerAlert(ThermalAlert.COLD_COMP_OFF.newAlert());
    }

    public void postStart() {
        this.publishState();
        this.inited = true;
        LOG.info("Thermal control system started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            if (!this.refrigGroup.equals(RefrigUtils.getGroupName((AgentInfo)agent))) continue;
            this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType") || !this.refrigGroup.equals(RefrigUtils.getGroupName((AgentInfo)agent))) continue;
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        this.refrigColdState = (ColdState)msg.getState().getState(ColdState.class);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state", level=0)
    public ThermalState getSystemState() {
        return this.thermalState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater operation state")
    public void setTrimHeaterState(int htr, TrimHeaterOpState state) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                TrimHeaterOpState oldState = this.thermalState.getTrimHeaterOpState(htr);
                if (state != oldState & this.thermalState.getTrimHeaterState(htr) != TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, state);
                    heater.tempCtrl.setOpState(state);
                    heater.inited = true;
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power set point")
    public void setTrimHeaterPower(int htr, double power) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setTrimHeaterPower(htr, power);
                heater.tempCtrl.setPower(power);
                heater.inited = true;
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a plate temperature set point")
    public void setPlateTemperature(int htr, double temp) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setPlateTemperature(htr, temp);
                heater.tempCtrl.setTemp(temp);
                heater.inited = true;
            }
            finally {
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off the bulk power supply")
    public void bulkPowerOn(boolean on) {
        this.heaterPs.setBulkPowerOn(on);
        this.publishState();
    }

    private void publishState() {
        this.thermalState.setTickMillis(this.monitorControl.getPublishPeriod());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.thermalState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThermalState() {
        if (!this.inited) {
            return;
        }
        boolean coldHigh = false;
        for (Channel chan : this.coldTemps) {
            coldHigh |= chan.getValue() > this.coldTempLimit;
        }
        if (coldHigh) {
            coldHigh &= ++this.highTempCount >= 3;
        } else {
            this.highTempCount = 0;
        }
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            SwitchState bulkPowerState;
            boolean changed = this.monitorControl.hasPeriodChanged();
            for (int htr : this.trimHeaterSet) {
                TrimHeaterState oldState;
                TrimHeater heater = this.trimHeaters[htr];
                TrimHeaterState state = coldHigh && htr != 0 ? TrimHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (heater.tempCtrl.isOverTemp() ? TrimHeaterState.OVRTEMP : (!heater.powerDevc.isEnabled(heater.powerChan) ? TrimHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? TrimHeaterState.VOLTERR : (heater.powerDevc.hasNoLoad(heater.powerChan) ? TrimHeaterState.NOLOAD : (this.thermalState.getTrimHeaterOpState(htr) == TrimHeaterOpState.TEMP ? TrimHeaterState.TEMP : TrimHeaterState.POWER))))));
                if (state == (oldState = this.thermalState.getTrimHeaterState(htr))) continue;
                this.thermalState.setTrimHeaterState(htr, state);
                if (oldState == TrimHeaterState.OFFLINE) {
                    if (!heater.inited) {
                        if (heater.powerDevc.isEnabled(heater.powerChan)) {
                            double power = heater.powerDevc.getPower(heater.powerChan);
                            this.thermalState.setTrimHeaterPower(htr, power);
                            heater.tempCtrl.setPower(power);
                            this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.POWER);
                            heater.tempCtrl.setOpState(TrimHeaterOpState.POWER);
                        } else {
                            this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.OFF);
                            heater.tempCtrl.setOpState(TrimHeaterOpState.OFF);
                        }
                        heater.inited = true;
                    } else {
                        heater.tempCtrl.setPower(this.thermalState.getTrimHeaterPower(htr));
                        heater.tempCtrl.setTemp(this.thermalState.getPlateTemperature(htr));
                        heater.tempCtrl.setOpState(this.thermalState.getTrimHeaterOpState(htr));
                    }
                }
                if (state == TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.OFF);
                    heater.tempCtrl.setOpState(TrimHeaterOpState.OFF);
                }
                changed = true;
            }
            Boolean bulkOn = this.heaterPs.isBulkPowerOn();
            SwitchState switchState = bulkOn == null ? SwitchState.OFFLINE : (bulkPowerState = bulkOn != false ? SwitchState.ON : SwitchState.OFF);
            if (bulkPowerState != this.thermalState.getBulkPowerState()) {
                this.thermalState.setBulkPowerState(bulkPowerState);
                changed = true;
            }
            if (changed) {
                boolean coldCompsOff;
                this.publishState();
                if (coldHigh) {
                    this.raiseAlert(ThermalAlert.COLD_TEMP_HIGH, AlertState.ALARM, "At least one cold-plate RTD is above " + this.coldTempLimit + " C");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_TEMP_HIGH, "No cold-plate RTD is above " + this.coldTempLimit + " C");
                }
                boolean bl = coldCompsOff = this.refrigColdState == ColdState.BOTH_OFF || this.refrigColdState == ColdState.UNKNOWN;
                if (coldCompsOff) {
                    this.raiseAlert(ThermalAlert.COLD_COMP_OFF, AlertState.ALARM, "Both cold compressors are turned off");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_COMP_OFF, "At least one cold compressor is back on");
                }
            }
        }
    }

    private void raiseAlert(ThermalAlert alert, AlertState state, String cond) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), true);
        if (wasActive != Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(), state, cond);
        }
    }

    private void lowerAlert(ThermalAlert alert, String cond) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), false);
        if (wasActive == Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(), AlertState.NOMINAL, cond);
        }
    }

    private TrimHeater getTrimHeater(int htr) throws RefrigException {
        if (!this.trimHeaterSet.contains(htr)) {
            throw new RefrigException("Invalid trim heater number: " + htr);
        }
        return this.trimHeaters[htr];
    }

    static {
        LinkedHashSet<Integer> trimSet = new LinkedHashSet<Integer>();
        trimSet.add(1);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(4);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(6);
        trimSet.add(5);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        LOG = Logger.getLogger(ThermalMain.class.getName());
    }

    static class TrimHeater {
        TrimHeaterControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;
        boolean inited = false;

        TrimHeater(TrimHeaterControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

