import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.refrig.OutputLine;
import org.lsst.ccs.subsystem.refrig.MonChannel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig"]

builder.
    main (RefrigTest, argMap("main", 10000, "hdw")) {

        Daq1       (MCCDevice, argMap("TC_AI", "00087534"))

        Daq2       (MCCDevice, argMap("TC_AI", "00097615"))

        Daq3       (MCCDevice, argMap("TEMP", null))

        WattsLoad  (WUDevice, argMap(null, "A4007Rxc"))

        WattsCmpr  (WUDevice, argMap(null, "A100KS6F"))

        MainPower  (OutputLine, argMap("MAIN", "Daq1", 7, null, -1))

        LoadPower  (OutputLine, argMap("LOAD", "Daq1", 6, "Daq2", 6))

        Alarm0     (OutputLine, argMap("ALARM", "Daq1", 0, "Daq2", 0))

        Alarm1     (OutputLine, argMap("ALARM", "Daq1", 1, "Daq2", 1))

        Alarm2     (OutputLine, argMap("ALARM", "Daq1", 2, "Daq2", 2))

        Alarm3     (OutputLine, argMap("ALARM", "Daq1", 3, "Daq2", 3))

        Alarm4     (OutputLine, argMap("ALARM", "Daq1", 4, "Daq2", 4))

        Alarm5     (OutputLine, argMap("ALARM", "Daq1", 5, "Daq2", 5))

        CmpDisTmp  (MonChannel,
                    argMap("Compressor discharge temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 0, "TEMP", "TC:T", 0, 0.0, 1.0))

        CmpDisPrs  (MonChannel,
                    argMap("Compressor discharge pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 6, "VOLTS", "1.25V", 1, -5.0, 10000.0))

        DwrLiqPrs  (MonChannel,
                    argMap("Dewar liquid pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq2", 4, "VOLTS", "1.25V", -1, 0.0, 5000.0))

        DwrVapPrs  (MonChannel,
                    argMap("Dewar vapor pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq2", 5, "VOLTS", "1.25V", -1, 0.0, 5000.0))

        DwrPrsDiff (MonChannel,
                    argMap("Dewar L/V pressure difference", "Psi",
                           "none", aDbl(limitLo, 0.0), 0.0,
                           "none", aDbl(limitHi, 0.0), 0.0,
                           null, 0, "DIFF", "DwrLiqPrs:DwrVapPrs", -1, 0, 0))

        C3LiqdTmp  (MonChannel,
                    argMap("C3 liquid cap temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 1, "TEMP", "TC:T", 2, 0.0, 1.0))

        PreC4Tmp   (MonChannel,
                    argMap("Pre C4 evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 2, "TEMP", "TC:T", 3, 0.0, 1.0))

        PostC4Tmp  (MonChannel,
                    argMap("Post C4 temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq2", 2, "TEMP", "TC:T", -1, 0.0, 1.0))

        PostEvpTmp (MonChannel,
                    argMap("Post evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq2", 0, "TEMP", "TC:T", -1, 0.0, 1.0))

        LoadTmp    (MonChannel,
                    argMap("Heat load temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "ltrip", aDbl(limitHi, 0.0), 2.0,
                           "Daq3", 0, "TEMP", "RTD:3WIRE", 4, 0.0, 1.0))

        DwrSucPrs  (MonChannel,
                    argMap("Dewar suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 5, "VOLTS", "5V", -1, 0.0, 20.0))

        CmpSucPrs  (MonChannel,
                    argMap("Compressor suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq1", 7, "VOLTS", "1.25V", 5, -0.53, 1000.0))

        SucPrsDiff (MonChannel,
                    argMap("Suction pressure difference", "Psi",
                           "none", aDbl(limitLo, 0.0), 0.0,
                           "none", aDbl(limitHi, 0.0), 0.0,
                           null, 0, "DIFF", "DwrSucPrs:CmpSucPrs", -1, 0, 0))

        LoadPower  (MonChannel,
                    argMap("Heat load power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "WattsLoad", 0, "POWER", "", -1, 0.0, 1.0))

        CmprPower  (MonChannel,
                    argMap("Compressor power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "WattsCmpr", 0, "POWER", "", -1, 0.0, 1.0))

        CmprVolts  (MonChannel,
                    argMap("Compressor line voltage", "Volts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "WattsCmpr", 1, "POWER", "", -1, 0.0, 1.0))

        AmbientTmp (MonChannel,
                    argMap("Ambient Temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "Daq2", 1, "TEMP", "TC:T", -1, 0.0, 1.0))
    }
