/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;

public class Subscale
extends Module
implements Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private static final double MAX_CURRENT = 2.0;
    private static final double MIN_VOLTAGE = 10.0;
    Monitor mon;
    String configName = "test";
    boolean coldStart;
    boolean running;
    boolean loadAlarm;
    int state;
    double loadPower;
    double loadVolts;
    double loadAmps = 2.0;
    double loadOhms;
    Line mainPowerLine;
    Line loadPowerLine;
    PowerDevice pwrDevc;

    public Subscale(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, log);
        this.mon.initConfiguration();
        this.mainPowerLine = this.mon.getLine("MainPower");
        if (this.mainPowerLine == null) {
            log.error((Object)"Compressor power control line (MainPower) not defined", new String[0]);
        }
        this.loadPowerLine = this.mon.getLine("LoadPower");
        if (this.loadPowerLine == null) {
            log.error((Object)"Heater power control line (LoadPower) not defined", new String[0]);
        }
        this.pwrDevc = (PowerDevice)this.mon.getDevice("Power");
        if (this.pwrDevc == null) {
            log.error((Object)"Heater power device (Power) not defined", new String[0]);
        }
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(!this.coldStart);
        }
        this.mon.initSensors();
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(false);
        }
        this.setMainPowerEnable(this.isMainPowerOn() ? 1 : 0);
        this.mon.start();
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration subscale camera test started");
            this.publishState();
            this.mon.publishState();
            this.mon.publishLimits();
            this.running = true;
        }
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (event) {
            case 0: {
                if (parm != 0 || (this.state & 2) != 0) break;
                this.state |= 2;
                this.setMainPowerEnable(0);
                this.publishState();
                break;
            }
            case 2: {
                if (parm != 0 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFFE;
        }
        this.setMainPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load power enabled state")
    public void setLoadPowerEnable(int value) {
        this.state = value != 0 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load power set point")
    public void setLoadPower(double value) {
        this.loadPower = value;
        this.setLoadPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        this.register(this.configName, "");
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), this.loadPower);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    int getState() {
        return this.state;
    }

    void publishState() {
        if (this.running) {
            RefrigState refgState = new RefrigState(this.state, this.getTickMillis(), this.loadPower);
            this.sendToStatus((Status)new RefrigStateStatus(refgState));
        }
    }

    void setMainPower() {
        boolean on;
        boolean bl = on = (this.state & 1) != 0;
        if (this.mainPowerLine != null) {
            this.mainPowerLine.set(on);
        }
        if (this.loadPowerLine != null) {
            this.loadPowerLine.set(on);
        }
    }

    void setLoadPower() {
        if (this.pwrDevc == null || !this.pwrDevc.isOnline()) {
            return;
        }
        boolean setOn = (this.state & 4) != 0;
        boolean pwrOn = this.pwrDevc.getOutput(0);
        if (!setOn) {
            if (pwrOn) {
                this.pwrDevc.setOutput(0, false);
            }
        } else {
            this.pwrDevc.setCurrent(0, this.loadAmps);
            if (this.loadOhms == 0.0) {
                this.pwrDevc.setVoltage(0, 10.0);
                this.pwrDevc.setOutput(0, true);
                double amps = this.pwrDevc.readCurrent(0);
                this.loadOhms = amps <= 0.0 ? 0.0 : this.pwrDevc.readVoltage(0) / amps;
            }
            this.loadVolts = Math.sqrt(this.loadPower * this.loadOhms);
            this.pwrDevc.setVoltage(0, this.loadVolts);
            this.pwrDevc.setOutput(0, true);
            int j = 0;
            while (j < 2) {
                if (this.loadVolts == 0.0) {
                    return;
                }
                double amps = this.pwrDevc.readCurrent(0);
                this.loadOhms = amps <= 0.0 ? 0.0 : this.pwrDevc.readVoltage(0) / amps;
                this.loadVolts = Math.sqrt(this.loadPower * this.loadOhms);
                this.pwrDevc.setVoltage(0, this.loadVolts);
                ++j;
            }
        }
    }

    boolean isMainPowerOn() {
        return this.mainPowerLine != null && this.mainPowerLine.isSet();
    }

    boolean isLoadPowerOn() {
        return this.loadPowerLine != null && this.loadPowerLine.isSet();
    }
}

