/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;

public class LongLines
extends Module
implements Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private static final int EVENT_ID_LOAD_POWER = 1;
    Monitor mon;
    String configName = "test";
    boolean coldStart;
    boolean running;
    boolean loadAlarm;
    int state = 4;
    Line mainPowerLine;
    Line loadPowerLine;

    public LongLines(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, log);
        this.mon.initConfiguration();
        this.mainPowerLine = this.mon.getLine("MainPower");
        this.loadPowerLine = this.mon.getLine("LoadPower");
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(!this.coldStart);
        }
        this.mon.initSensors();
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(false);
        }
        this.setMainPowerEnable(this.isMainPowerOn() ? 1 : 0);
        this.setLoadPower();
        this.mon.start();
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration long lines test system started");
            this.publishState();
            this.mon.publishState();
            this.mon.publishLimits();
            this.running = true;
        }
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (event) {
            case 0: {
                if (parm == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setMainPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (parm != 1) break;
                this.loadAlarm = true;
                if ((this.state & 8) == 0) break;
                this.state &= 0xFFFFFFFB;
                this.setLoadPower();
                this.publishState();
                break;
            }
            case 2: {
                if (parm == 0 && (this.state & 2) != 0) {
                    this.state &= 0xFFFFFFFD;
                    this.publishState();
                }
                if (parm != 1) break;
                this.loadAlarm = false;
                if ((this.state & 8) == 0) break;
                this.state |= 4;
                this.setLoadPower();
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFFE;
        }
        this.setMainPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the load power trip enabled state")
    public void setLoadTripEnable(int value) {
        if (value != 0) {
            this.state |= 8;
            if (this.loadAlarm) {
                this.state &= 0xFFFFFFFB;
                this.setLoadPower();
            }
        } else {
            this.state &= 0xFFFFFFF7;
            if ((this.state & 4) == 0) {
                this.state |= 4;
                this.setLoadPower();
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        this.register(this.configName, "");
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full refrigeration state")
    public RefrigFullState getFullState() {
        RefrigState refgState = new RefrigState(this.state, this.getTickMillis());
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(refgState, monState);
    }

    int getState() {
        return this.state;
    }

    void publishState() {
        if (this.running) {
            RefrigState refgState = new RefrigState(this.state, this.getTickMillis());
            this.sendToStatus((Status)new RefrigStateStatus(refgState));
        }
    }

    void setMainPower() {
        if (this.mainPowerLine != null) {
            this.mainPowerLine.set((this.state & 1) != 0);
        }
    }

    void setLoadPower() {
        if (this.loadPowerLine != null) {
            this.loadPowerLine.set((this.state & 4) != 0);
        }
    }

    boolean isMainPowerOn() {
        return this.mainPowerLine != null && this.mainPowerLine.isSet();
    }

    boolean isLoadPowerOn() {
        return this.loadPowerLine != null && this.loadPowerLine.isSet();
    }
}

