/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.sorensen.Dcs;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class DcsDevice
extends Device
implements PowerDevice {
    static final int CHAN_POWER = 0;
    static final int CHAN_VOLTAGE = 1;
    static final int CHAN_CURRENT = 2;
    static final int N_HW_CHANS = 3;
    private static final Map<String, Integer> cTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    String connTypeS;
    String ident;
    int connType;
    Dcs dcs;
    double[] values = new double[3];

    static {
        cTypeMap.put("SERIAL", 2);
        cTypeMap.put("FTDI", 1);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("POWER", 2);
    }

    public DcsDevice(String cType, String id) {
        this.ident = id;
        this.connTypeS = cType;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "Sorensen DCS module (" + this.ident + ")";
        Integer iConnType = cTypeMap.get(this.connTypeS);
        if (iConnType == null) {
            this.connType = -1;
            try {
                mon.reportError(this.getName(), "connection type", (Object)this.connTypeS);
            }
            catch (Exception exception) {}
        } else {
            this.connType = iConnType;
        }
    }

    protected void initialize() {
        block10: {
            if (this.connType < 0) {
                return;
            }
            try {
                try {
                    if (!this.inited || this.dcs == null) {
                        this.dcs = new Dcs();
                    }
                    this.dcs.open(this.connType, this.ident);
                    this.setOnline(true);
                    this.dcs.setOutput(false);
                    this.dcs.setVoltage(0.0);
                    String message = "Connected to " + this.fullName;
                    if (!this.inited) {
                        this.log.info((Object)message, new String[0]);
                        break block10;
                    }
                    this.log.error((Object)message, new String[0]);
                }
                catch (Exception e) {
                    if (!this.inited) {
                        this.log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                    }
                    if (this.dcs != null) {
                        this.close();
                    }
                    this.inited = true;
                }
            }
            finally {
                this.inited = true;
            }
        }
    }

    protected void close() {
        try {
            this.dcs.close();
        }
        catch (DriverException driverException) {}
        int j = 0;
        while (j < 3) {
            this.values[j] = 0.0;
            ++j;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "HW channel", (Object)hwChan);
        }
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        return new int[]{iType, iSubtype};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            this.values[1] = this.dcs.readVoltage();
            this.values[2] = this.dcs.readCurrent();
            this.values[0] = this.values[1] * this.values[2];
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.values[hwChan];
    }

    @Override
    public void setOutput(int chan, boolean value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setOutput(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chan) {
        if (!this.testOnline()) {
            return false;
        }
        try {
            return this.dcs.getOutput();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return false;
        }
    }

    @Override
    public void setVoltage(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setVoltage(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.dcs.readVoltage();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setCurrent(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
        }
    }

    @Override
    public double readCurrent(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.dcs.readCurrent();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)), new String[0]);
            this.setOnline(false);
            return -1.0;
        }
    }
}

