import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.
    main (Subscale, argMap("main", 10000, "")) {

        Cmpr       (MCCDevice, argMap("TC_AI", "00087534"))

        Mod1       (MCCDevice, argMap("TC_AI", "00099707"))

        Mod2       (MCCDevice, argMap("TEMP", "018F9BA8"))

        Mod3       (MCCDevice, argMap("TEMP", "018F9BAA"))

        Power      (DcsDevice, argMap("FTDI", "A602LIHA"))

        WattsCmpr  (WUDevice, argMap(null, "A100KS6F"))

        MainPower  (Line, argMap("Cmpr", 7, null, 0))

        LoadPower  (Line, argMap("Mod1", 0, null, 0))

        AlarmCmpr  (Alarm, argMap(null, 0))

        AlarmHtr   (Alarm, argMap(null, 1))

        CmpDisTmp  (Channel,
                    argMap("Compressor discharge temperature", "C",
                           "Cmpr", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpRetnTmp (Channel,
                    argMap("Compressor oil return temperature", "C",
                           "Cmpr", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpSepTmp  (Channel,
                    argMap("Compressor separator temperature", "C",
                           "Cmpr", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpDisPrs  (Channel,
                    argMap("Compressor discharge pressure", "Psig",
                           "Cmpr", 4, "VOLTS", "1.25V", -5.0, 10000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmpSucPrs  (Channel,
                    argMap("Compressor suction pressure", "Psig",
                           "Cmpr", 5, "VOLTS", "1.25V", -0.53, 1000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CmpFlowSwi (Channel,
                    argMap("Compressor flow switch state", "",
                           "Cmpr", 1, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        CmpTmpRly  (Channel,
                    argMap("Compressor temperature relay state", "",
                           "Cmpr", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        CmprPower  (Channel,
                    argMap("Compressor power", "Watts",
                           "WattsCmpr", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "alarm", aDbl(limitHi, 0.0), 0.0, "AlarmCmpr"))

        CmprVolts  (Channel,
                    argMap("Compressor line voltage", "Volts",
                           "WattsCmpr", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadTmp1   (Channel,
                    argMap("Heat load temperature 1", "C",
                           "Mod3", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 2.0, null))

        LoadTmp2   (Channel,
                    argMap("Heat load temperature 2", "C",
                           "Mod3", 2, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 2.0, null))

        LoadTmp3   (Channel,
                    argMap("Heat load temperature 3", "C",
                           "Mod3", 4, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 2.0, null))

        LoadTmp4   (Channel,
                    argMap("Heat load temperature 4", "C",
                           "Mod3", 6, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 2.0, null))

        LoadTmp5   (Channel,
                    argMap("Heat load temperature 5", "C",
                           "Mod2", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 2.0, null))

        C3LiqdTmp  (Channel,
                    argMap("C3 liquid cap temperature", "C",
                           "Mod1", 0, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PreC4Tmp   (Channel,
                    argMap("Pre C4 temperature", "C",
                           "Mod1", 1, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Tmp  (Channel,
                    argMap("Post C4 temperature", "C",
                           "Mod1", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        PostCryTmp (Channel,
                    argMap("Post cryo temperature", "C",
                           "Mod1", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        RelayTmp   (Channel,
                    argMap("Relay temperature", "C",
                           "Mod2", 2, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexExitTmp (Channel,
                    argMap("HEX exit temperature", "C",
                           "Mod2", 3, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryFlxTmp1 (Channel,
                    argMap("Cryo flex hose temperature 1", "C",
                           "Mod2", 4, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        CryFlxTmp2 (Channel,
                    argMap("Cryo flex hose temperature 2", "C",
                           "Mod2", 5, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        TubeMidTmp (Channel,
                    argMap("Tube midpoint temperature", "C",
                           "Mod2", 6, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        AprnAmbTmp (Channel,
                    argMap("Apron ambient temperature", "C",
                           "Mod2", 7, "TEMP", "TC:T", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexLiqPrs  (Channel,
                    argMap("HEX liquid pressure", "Psig",
                           "Mod1", 4, "VOLTS", "1.25V", 0.0, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexVapPrs  (Channel,
                    argMap("HEX vapor pressure", "Psig",
                           "Mod1", 5, "VOLTS", "1.25V", 0.0, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexPrsDiff (Channel,
                    argMap("HEX liq/vap pressure difference", "Psi",
                           null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                           "none", aDbl(limitLo, 0.0), 0.0, null,
                           "none", aDbl(limitHi, 0.0), 0.0, null))

        PostC4Prs  (Channel,
                    argMap("Post C4 pressure", "Psig",
                           "Mod1", 6, "VOLTS", "1.25V", 0.0, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        HexSucPrs  (Channel,
                    argMap("HEX suction pressure", "Psig",
                           "Mod1", 7, "VOLTS", "1.25V", 0.0, 5000.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadPower  (Channel,
                    argMap("Heater power", "Watts",
                           "Power", 0, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        LoadVolts  (Channel,
                    argMap("Heater voltage", "Volts",
                           "Power", 1, "POWER", "", 0.0, 1.0,
                           "flag", aDbl(limitLo, 0.0), 0.0, null,
                           "flag", aDbl(limitHi, 0.0), 0.0, null))

        Running    (Channel,
                    argMap("Running state", "",
                           "Mod1", 6, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        Interlock  (Channel,
                    argMap("Interlock state", "",
                           "Mod1", 2, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        ThermRelay (Channel,
                    argMap("Thermal relay state", "",
                           "Mod1", 3, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        LoadEnable (Channel,
                    argMap("Load enable state", "",
                           "Mod1", 4, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))

        V5Power    (Channel,
                    argMap("5-Volt power state", "",
                           "Mod1", 5, "SWITCH", "", 0, 1,
                           "flag", aDbl(limitLo, 1.0), 0, null,
                           "flag", aDbl(limitHi, 1.0), 0, null))
    }
