import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigTestSim;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig"]

builder.
    main (RefrigTestSim,
          argMap("main", 10000, "sim")) {

        CmpDisTmp  (RefrigTestSim.ChannelSim,
                    argMap("Compressor discharge temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           110.0, 120.0, 10.0, 1200.0))

        CmpDisPrs  (RefrigTestSim.ChannelSim,
                    argMap("Compressor discharge pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           300.0, 30.0, 50.0, 30.0))

        C3LiqdTmp  (RefrigTestSim.ChannelSim,
                    argMap("C3 liquid cap temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           -120.0, 1800.0, 25.0, 7200.0))

        PreC4Tmp   (RefrigTestSim.ChannelSim,
                    argMap("Pre C4 evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           -120.0, 1800.0, 25.0, 7200.0))

        PostEvpTmp (RefrigTestSim.ChannelSim,
                    argMap("Post evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           -110.0, 1800.0, 25.0, 7200.0))

        LoadTmp    (RefrigTestSim.ChannelSim,
                    argMap("Heat load temperature", "C",
                          "flag", aDbl(limitLo, 0.0), 0.0,
                          "ltrip", aDbl(limitHi, 0.0), 2.0,
                          -100.0, 1800.0, 25.0, 7200.0))

        LoadTmpTC  (RefrigTestSim.ChannelSim,
                    argMap("Heat load temperature (TC)", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           -100.0, 1800.0, 25.0, 7200.0))

        CmpSucPrs  (RefrigTestSim.ChannelSim,
                    argMap("Compressor suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           10.0, 30.0, 50.0, 30.0))

        LoadPower  (RefrigTestSim.ChannelSim,
                    argMap("Heat load power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           200.0, 0.0, 0.0, 0.0))

        CmprPower  (RefrigTestSim.ChannelSim,
                    argMap("Compressor power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           1050.0, 0.0, 0.0, 0.0))

        CmprVolts  (RefrigTestSim.ChannelSim,
                    argMap("Compressor line voltage", "Volts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           208.0, 0.0, 0.0, 0.0))

        FanAlarm   (RefrigTestSim.ChannelSim,
                    argMap("Compressor purge fan alarm", "",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           1.0, 0.0, 1.0, 0.0))
    }
