import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigTestHdw;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig"]

builder.
    main (RefrigTestHdw,
          argMap("main", 10000, "hdw")) {

        MccTcAi1   (RefrigTestHdw.MccDevc, argMap("TC_AI", "00087534"))

        MccTcAi2   (RefrigTestHdw.MccDevc, argMap("TC_AI", "00097615"))

        MccTemp    (RefrigTestHdw.MccDevc, argMap("TEMP", null))

        WattsLoad  (RefrigTestHdw.WuDevc, argMap(null, null))

        WattsCmpr  (RefrigTestHdw.WuDevc, argMap("ppa-pc66117-l", "A100KS6F"))

        MainPower  (RefrigTestHdw.OutputLine, argMap("MAIN", 7, -1))

        LoadPower  (RefrigTestHdw.OutputLine, argMap("LOAD", 6, 14))

        Alarm0     (RefrigTestHdw.OutputLine, argMap("ALARM", 0, 8))

        Alarm1     (RefrigTestHdw.OutputLine, argMap("ALARM", 1, 9))

        Alarm2     (RefrigTestHdw.OutputLine, argMap("ALARM", 2, 10))

        Alarm3     (RefrigTestHdw.OutputLine, argMap("ALARM", 3, 11))

        Alarm4     (RefrigTestHdw.OutputLine, argMap("ALARM", 4, 12))

        Alarm5     (RefrigTestHdw.OutputLine, argMap("ALARM", 5, 13))

        CmpDisTmp  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor discharge temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 0, 0, 0.0, 1.0))

        CmpDisPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor discharge pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 6, 1, -5.0, 10000.0))

        DwrLiqPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Dewar liquid pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 12, -1, 0.0, 5000.0))

        DwrVapPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Dewar vapor pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 13, -1, 0.0, 5000.0))

        C3LiqdTmp  (RefrigTestHdw.ChannelHdw,
                    argMap("C3 liquid cap temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 1, 2, 0.0, 1.0))

        PreC4Tmp   (RefrigTestHdw.ChannelHdw,
                    argMap("Pre C4 evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 2, 3, 0.0, 1.0))

        PostC4Tmp  (RefrigTestHdw.ChannelHdw,
                    argMap("Post C4 temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 10, -1, 0.0, 1.0))

        PostEvpTmp (RefrigTestHdw.ChannelHdw,
                    argMap("Post evaporator temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 8, -1, 0.0, 1.0))

        LoadTmp    (RefrigTestHdw.ChannelHdw,
                    argMap("Heat load temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "ltrip", aDbl(limitHi, 0.0), 2.0,
                           "TEMP", "RTD:3WIRE", 16, 4, 0.0, 1.0))

        DwrSucPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Dewar suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "5V", 5, -1, 0.0, 20.0))

        CmpSucPrs  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor suction pressure", "Psig",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "VOLTS", "1.25V", 7, 5, -0.53, 1000.0))

        SucPrsDiff (RefrigTestHdw.ChannelHdw,
                    argMap("Suction pressure difference", "Psi",
                           "none", aDbl(limitLo, 0.0), 0.0,
                           "none", aDbl(limitHi, 0.0), 0.0,
                           "DIFF", "DwrSucPrs:CmpSucPrs", 0, -1, 0, 0))

        LoadPower  (RefrigTestHdw.ChannelHdw,
                    argMap("Heat load power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 0, -1, 0.0, 1.0))

        CmprPower  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor power", "Watts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "mtrip", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 2, -1, 0.0, 1.0))

        CmprVolts  (RefrigTestHdw.ChannelHdw,
                    argMap("Compressor line voltage", "Volts",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "POWER", "", 3, -1, 0.0, 1.0))

        AmbientTmp (RefrigTestHdw.ChannelHdw,
                    argMap("Ambient Temperature", "C",
                           "flag", aDbl(limitLo, 0.0), 0.0,
                           "flag", aDbl(limitHi, 0.0), 0.0,
                           "TEMP", "TC:T", 9, -1, 0.0, 1.0))
    }
