/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;

public class RefrigTestHdw
extends RefrigTest {
    private static final long CHECK_PERIOD = 10000L;
    private List<Device> devcData = new ArrayList<Device>();
    private List<MccDevc> mccData = new ArrayList<MccDevc>();
    private List<WuDevc> wuData = new ArrayList<WuDevc>();
    private ChannelHdw[] chanDataHdw;
    private OutputLine mainPowerLine;
    private OutputLine loadPowerLine;
    private List<OutputLine> alarmLine = new ArrayList<OutputLine>();

    public RefrigTestHdw(String name, int tickMillis, String configName) {
        super(name, tickMillis, configName);
    }

    @Override
    void initConfiguration() {
        for (MccDevc mccDev : this.getChildren(MccDevc.class).values()) {
            this.mccData.add(mccDev);
            mccDev.configure(this);
            this.devcData.add(mccDev);
        }
        for (WuDevc wuDev : this.getChildren(WuDevc.class).values()) {
            this.wuData.add(wuDev);
            wuDev.configure(this);
            this.devcData.add(wuDev);
        }
        int id = 0;
        for (OutputLine line : this.getChildren(OutputLine.class).values()) {
            line.configure(this, id++);
            if (line.type == 0) {
                this.mainPowerLine = line;
                continue;
            }
            if (line.type == 1) {
                this.loadPowerLine = line;
                continue;
            }
            if (line.type != 2) continue;
            this.alarmLine.add(line);
        }
        Map chanMap = this.getChildren(ChannelHdw.class);
        this.chanData = new ChannelHdw[chanMap.size()];
        this.chanDataHdw = (ChannelHdw[])this.chanData;
        id = 0;
        for (ChannelHdw ch : chanMap.values()) {
            ch.configure(this, id);
            this.chanDataHdw[id++] = ch;
        }
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch;
            ch = channelHdwArray[n2];
            ch.configDerived();
            ++n2;
        }
    }

    @Override
    void initSensors() {
        for (Device devc : this.devcData) {
            devc.initialize(true);
        }
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            ch.initSensor();
            ++n2;
        }
        new Timer(true).schedule((TimerTask)new CheckDevices(), 0L, 10000L);
    }

    @Override
    void readSensors() {
        ChannelHdw ch;
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.readSensor();
            ++n2;
        }
        channelHdwArray = this.chanDataHdw;
        n = this.chanDataHdw.length;
        n2 = 0;
        while (n2 < n) {
            ch = channelHdwArray[n2];
            ch.calcDerived();
            ++n2;
        }
    }

    @Override
    void setMainPower(boolean on) {
        if (this.mainPowerLine == null) {
            return;
        }
        this.mainPowerLine.set(on);
    }

    @Override
    void setLoadPower(boolean on) {
        if (this.loadPowerLine == null) {
            return;
        }
        this.loadPowerLine.set(on);
    }

    @Override
    boolean isMainPowerOn() {
        boolean on = false;
        if (this.mainPowerLine != null) {
            on = this.mainPowerLine.isSet();
        }
        return on;
    }

    @Override
    boolean isLoadPowerOn() {
        boolean on = false;
        if (this.loadPowerLine != null) {
            on = this.loadPowerLine.isSet();
        }
        return on;
    }

    @Override
    void setDisplay(int mask, int state) {
        ChannelHdw[] channelHdwArray = this.chanDataHdw;
        int n = this.chanDataHdw.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelHdw ch = channelHdwArray[n2];
            if (ch.alarm >= 0 && (mask & 1 << ch.id) != 0) {
                this.alarmLine.get(ch.alarm).set((state >> ch.id & 1) == 0);
            }
            ++n2;
        }
    }

    void setAlarm(int alarm, boolean on) {
        if (alarm < 0 || alarm >= this.alarmLine.size()) {
            return;
        }
        this.alarmLine.get(alarm).set(on);
    }

    boolean checkAlarm(int alarm) {
        return alarm < this.alarmLine.size();
    }

    private Device getDevice(int type, int chan) {
        Device devc = null;
        if (type == 0) {
            if (chan >= 0 && chan < 8 * this.mccData.size()) {
                devc = this.mccData.get(chan / 8);
            }
        } else if (type == 1 && chan >= 0 && chan < 2 * this.wuData.size()) {
            devc = this.wuData.get(chan / 2);
        }
        return devc;
    }

    private int getDevChan(int type, int chan) {
        int devChan = -1;
        if (type == 0) {
            devChan = chan % 8;
        } else if (type == 1) {
            devChan = chan % 2;
        }
        return devChan;
    }

    private static void checkUsbException(Exception e) {
        if (e instanceof UsbException || e instanceof UsbDisconnectedException || e instanceof UsbEncodingException || e instanceof UsbNotActiveException || e instanceof UsbNotOpenException || e instanceof UsbNotClaimedException) {
            return;
        }
        throw (RuntimeException)e;
    }

    public static class ChannelHdw
    extends RefrigTest.Channel {
        private static final int TYPE_UNKNOWN = -1;
        private static final int TYPE_TEMP = 0;
        private static final int TYPE_VOLTS = 1;
        private static final int TYPE_POWER = 2;
        private static final int TYPE_SWITCH = 3;
        private static final int TYPE_DIFF = 4;
        String typeS;
        String subtypeS;
        int chan;
        int alarm;
        float offset;
        float scale;
        int type;
        int subtype;
        Device device;
        int devChan;
        private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
        private static final Map<String, Integer> tSbTypMap;
        private static final Map<String, Integer> tcSbTypMap;
        private static final Map<String, Integer> rtSbTypMap;
        private static final Map<String, Integer> vSbTypMap;

        static {
            typeMap.put("TEMP", 0);
            typeMap.put("VOLTS", 1);
            typeMap.put("POWER", 2);
            typeMap.put("SWITCH", 3);
            typeMap.put("DIFF", 4);
            tSbTypMap = new HashMap<String, Integer>();
            tSbTypMap.put("TC", 2);
            tSbTypMap.put("RTD", 0);
            tcSbTypMap = new HashMap<String, Integer>();
            tcSbTypMap.put("J", 0);
            tcSbTypMap.put("K", 1);
            tcSbTypMap.put("T", 2);
            tcSbTypMap.put("E", 3);
            tcSbTypMap.put("R", 4);
            tcSbTypMap.put("S", 5);
            tcSbTypMap.put("B", 6);
            tcSbTypMap.put("N", 7);
            rtSbTypMap = new HashMap<String, Integer>();
            rtSbTypMap.put("2WIRE1", 0);
            rtSbTypMap.put("2WIRE2", 1);
            rtSbTypMap.put("3WIRE", 2);
            rtSbTypMap.put("4WIRE", 3);
            vSbTypMap = new HashMap<String, Integer>();
            vSbTypMap.put("10V", 2);
            vSbTypMap.put("5V", 3);
            vSbTypMap.put("2.5V", 4);
            vSbTypMap.put("1.25V", 5);
        }

        public ChannelHdw(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi, String type, String subtype, int chan, int alarm, double offset, double scale) {
            super(desc, units, loCheck, limitLo, deadbandLo, hiCheck, limitHi, deadbandHi);
            this.typeS = type;
            this.subtypeS = subtype;
            this.chan = chan;
            this.alarm = alarm;
            this.offset = (float)offset;
            this.scale = (float)scale;
        }

        void configure(RefrigTestHdw refg, int id) {
            super.configure(refg, id);
            int iType = -1;
            int iSubtype = -1;
            int iChan = -1;
            int iAlarm = -1;
            try {
                Integer iTyp = typeMap.get(this.typeS.toUpperCase());
                if (iTyp == null) {
                    RefrigTestHdw.reportError(this.getName(), "type", this.typeS);
                }
                iType = iTyp;
                String sbtype = this.subtypeS.toUpperCase();
                if (iType == 0) {
                    Integer iStp;
                    String[] sbtypes = sbtype.split(":", -1);
                    if (sbtypes.length < 2) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    if ((iStp = tSbTypMap.get(sbtypes[0])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                    if ((iStp = iStp == 0 ? rtSbTypMap.get(sbtypes[1]) : tcSbTypMap.get(sbtypes[1])) == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype |= iStp << 8;
                } else if (iType == 1) {
                    Integer iStp = vSbTypMap.get(sbtype);
                    if (iStp == null) {
                        RefrigTestHdw.reportError(this.getName(), "subtype", this.subtypeS);
                    }
                    iSubtype = iStp;
                }
                boolean chanOk = true;
                if (iType == 0 || iType == 1 || iType == 3) {
                    this.device = refg.getDevice(0, this.chan);
                    this.devChan = refg.getDevChan(0, this.chan);
                    if (this.device != null) {
                        MccDevc mccDev = (MccDevc)this.device;
                        if (iType == 0) {
                            int mask = mccDev.tcMask;
                            if ((iSubtype & 0xFF) == 0) {
                                mask = mccDev.rtMask;
                            }
                            if ((1 << this.devChan & mask) == 0) {
                                chanOk = false;
                            }
                        } else if (iType == 1 && (1 << this.devChan & mccDev.vMask) == 0) {
                            chanOk = false;
                        }
                    } else {
                        chanOk = false;
                    }
                } else if (iType == 2) {
                    this.device = refg.getDevice(1, this.chan);
                    this.devChan = refg.getDevChan(1, this.chan);
                    if (this.device == null) {
                        chanOk = false;
                    }
                }
                if (!chanOk) {
                    RefrigTestHdw.reportError(this.getName(), "hw channel number", this.chan);
                }
                if (this.device != null) {
                    this.device.addChannel(id);
                }
                iChan = this.chan;
                if (!refg.checkAlarm(this.alarm)) {
                    RefrigTestHdw.reportError(this.getName(), "alarm number", this.alarm);
                }
                iAlarm = this.alarm;
            }
            catch (Exception exception) {}
            this.type = iType;
            this.subtype = iSubtype;
            this.chan = iChan;
            this.alarm = iAlarm;
        }

        void configDerived() {
            if (this.type != 4) {
                return;
            }
            String[] names = this.subtypeS.split(":", -1);
            boolean okay = false;
            if (names.length == 2) {
                RefrigTestHdw refgHdw = (RefrigTestHdw)this.refg;
                int id0 = refgHdw.findChannelId(names[0]);
                int id1 = refgHdw.findChannelId(names[1]);
                if (id0 >= 0 && id1 >= 0) {
                    this.subtype = id0 << 16 | id1;
                    okay = true;
                    this.refg.setOnline(1 << this.id, true);
                }
            }
            if (!okay) {
                log.error((Object)("Invalid subtype (" + this.subtypeS + ") for " + this.getName()), new String[0]);
                this.type = -1;
            }
        }

        void initSensor() {
            if (this.device == null || this.device.type != 0 || !this.device.online) {
                return;
            }
            MccUsb mcc = ((MccDevc)this.device).mcc;
            try {
                if (this.type == 0) {
                    int sType = this.subtype & 0xFF;
                    int tType = this.subtype >> 8;
                    mcc.setSensorType(this.devChan, sType);
                    if (sType == 0) {
                        mcc.setThermConnType(this.devChan, tType);
                        mcc.setExcitation(this.devChan, 2);
                        mcc.setGain(this.devChan, 2);
                        int j = 0;
                        while (j < MccDevc.RTD_COEFFS.length) {
                            mcc.setCoefficient(this.devChan, j, MccDevc.RTD_COEFFS[j]);
                            ++j;
                        }
                    } else {
                        mcc.setTCType(this.devChan, tType);
                    }
                } else if (this.type == 1) {
                    mcc.setGain(this.devChan, this.subtype);
                    mcc.setVoltageConnType(this.devChan, 0);
                } else if (this.type == 3) {
                    mcc.dioConfigBit(this.devChan, 1);
                }
            }
            catch (Exception e) {
                RefrigTestHdw.checkUsbException(e);
                log.error((Object)("Error configuring " + this.device.fullName + ": " + e), new String[0]);
                this.device.setOnline(false);
            }
        }

        void readSensor() {
            if (this.device == null) {
                return;
            }
            if (this.device.type == 1) {
                this.value = ((WuDevc)this.device).value[this.devChan];
            } else if (this.device.type == 0) {
                if (!this.device.online) {
                    return;
                }
                MccUsb mcc = ((MccDevc)this.device).mcc;
                if (this.type == 3) {
                    try {
                        this.value = mcc.dioInBit(this.devChan);
                    }
                    catch (Exception e) {
                        RefrigTestHdw.checkUsbException(e);
                        log.error((Object)("Error reading DIO line: " + e), new String[0]);
                        this.device.setOnline(false);
                    }
                } else {
                    try {
                        this.value = this.offset + this.scale * mcc.adcIn(this.devChan, 0);
                    }
                    catch (Exception e) {
                        RefrigTestHdw.checkUsbException(e);
                        log.error((Object)("Error reading ADC: " + e), new String[0]);
                        this.device.setOnline(false);
                    }
                }
            }
        }

        void calcDerived() {
            if (this.type != 4) {
                return;
            }
            this.value = this.refg.getChannel((int)(this.subtype >> 16)).value - this.refg.getChannel((int)(this.subtype & 0xFFFF)).value;
        }
    }

    private class CheckDevices
    extends TimerTask {
        private CheckDevices() {
        }

        @Override
        public void run() {
            for (Device devc : RefrigTestHdw.this.devcData) {
                devc.checkOnline();
            }
        }
    }

    public static abstract class Device {
        static final int TYPE_MCC = 0;
        static final int TYPE_WATTS = 1;
        int type;
        String fullName;
        int chanMask;
        RefrigTestHdw refg;
        boolean online;

        void configure(RefrigTestHdw refg) {
            this.refg = refg;
        }

        abstract void initialize(boolean var1);

        void addChannel(int id) {
            this.chanMask |= 1 << id;
        }

        abstract void checkOnline();

        void setOnline(boolean online) {
            this.online = online;
            this.refg.setOnline(this.chanMask, online);
            if (!online) {
                log.error((Object)("Disconnected from " + this.fullName), new String[0]);
                this.close();
            }
        }

        abstract void close();
    }

    public static class MccDevc
    extends Device {
        static final int N_DEV_CHANS = 8;
        static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
        String dName;
        String serial;
        int did;
        MccUsb mcc;
        int tcMask;
        int rtMask;
        int vMask;
        int lineMask;
        private static final Map<String, Integer> didMap = new HashMap<String, Integer>();

        static {
            didMap.put("TC_AI", 0);
            didMap.put("TC", 1);
            didMap.put("TEMP", 2);
        }

        public MccDevc(String devName, String serialNo) {
            this.type = 0;
            this.dName = devName;
            this.serial = serialNo;
            this.fullName = "MCC " + this.dName + " module" + (this.serial == null ? "" : " (" + this.serial + ")");
            Integer iDid = didMap.get(this.dName);
            if (iDid == null) {
                log.error((Object)("Invalid MCC device type (" + this.dName + ")"), new String[0]);
                this.did = -1;
            } else {
                this.did = iDid;
                if (this.did == 0) {
                    this.tcMask = 15;
                    this.vMask = 240;
                } else if (this.did == 1) {
                    this.tcMask = 255;
                } else if (this.did == 2) {
                    this.tcMask = 255;
                    this.rtMask = 255;
                }
            }
        }

        @Override
        void initialize(boolean first) {
            block12: {
                if (this.did < 0) {
                    return;
                }
                try {
                    int j;
                    if (first || this.mcc == null) {
                        this.mcc = new MccUsb();
                    }
                    this.mcc.open(this.did, this.serial, true);
                    this.mcc.blink();
                    this.mcc.dioConfig(0);
                    if (this.did == 0) {
                        j = 0;
                        while (j < 8) {
                            this.mcc.configAlarm(j, 0, 0, 0.0f, 0.0f);
                            ++j;
                        }
                    } else if (this.did == 2) {
                        j = 0;
                        while (j < 8) {
                            this.mcc.setSensorType(j, 4);
                            j += 2;
                        }
                    }
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (first) {
                        log.info((Object)message, new String[0]);
                    } else {
                        log.error((Object)message, new String[0]);
                    }
                }
                catch (Exception e) {
                    RefrigTestHdw.checkUsbException(e);
                    if (first) {
                        log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                    }
                    if (this.mcc == null) break block12;
                    this.close();
                }
            }
        }

        void addLine(int id) {
            this.lineMask |= 1 << id;
        }

        @Override
        void checkOnline() {
            if (this.online) {
                return;
            }
            this.initialize(false);
            if (!this.online) {
                return;
            }
            int id = 0;
            while (id < 24) {
                if ((this.chanMask & 1 << id) != 0) {
                    ((ChannelHdw)this.refg.getChannel(id)).initSensor();
                }
                ++id;
            }
            if (this.lineMask != 0) {
                this.refg.setOutputLines();
            }
        }

        @Override
        void close() {
            try {
                this.mcc.close();
            }
            catch (Exception e) {
                RefrigTestHdw.checkUsbException(e);
            }
        }
    }

    public static class OutputLine {
        private static final int TYPE_UNKNOWN = -1;
        private static final int TYPE_MAIN_POWER = 0;
        private static final int TYPE_LOAD_POWER = 1;
        private static final int TYPE_ALARM = 2;
        String typeS;
        int chan;
        int chanC;
        int type;
        MccDevc device;
        int devChan;
        MccDevc deviceC;
        int devChanC;
        private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();

        static {
            typeMap.put("MAIN", 0);
            typeMap.put("LOAD", 1);
            typeMap.put("ALARM", 2);
        }

        public OutputLine(String type, int chan, int chanC) {
            this.typeS = type;
            this.chan = chan;
            this.chanC = chanC;
        }

        void configure(RefrigTestHdw refg, int id) {
            Integer iType = typeMap.get(this.typeS);
            if (iType == null) {
                log.error((Object)("Invalid output line type: " + this.typeS), new String[0]);
                this.type = -1;
                return;
            }
            this.type = iType;
            if (this.chan >= 0) {
                this.device = (MccDevc)refg.getDevice(0, this.chan);
                this.devChan = refg.getDevChan(0, this.chan);
                if (this.device != null) {
                    this.device.addLine(id);
                } else {
                    log.error((Object)("Invalid output line channel: " + this.chan), new String[0]);
                }
            }
            if (this.chanC >= 0) {
                this.deviceC = (MccDevc)refg.getDevice(0, this.chanC);
                this.devChanC = refg.getDevChan(0, this.chanC);
                if (this.deviceC != null) {
                    this.deviceC.addLine(id);
                } else {
                    log.error((Object)("Invalid output line channel: " + this.chanC), new String[0]);
                }
            }
        }

        void set(boolean on) {
            int value;
            int n = value = on ? 1 : 0;
            if (this.device != null && this.device.online) {
                try {
                    this.device.mcc.dioOutBit(this.devChan, value);
                }
                catch (Exception e) {
                    RefrigTestHdw.checkUsbException(e);
                    log.error((Object)("Error setting DIO line: " + e), new String[0]);
                    this.device.setOnline(false);
                }
            }
            if (this.deviceC != null && this.deviceC.online) {
                try {
                    this.deviceC.mcc.dioOutBit(this.devChanC, value ^ 1);
                }
                catch (Exception e) {
                    RefrigTestHdw.checkUsbException(e);
                    log.error((Object)("Error setting DIO line: " + e), new String[0]);
                    this.deviceC.setOnline(false);
                }
            }
        }

        boolean isSet() {
            int value = 0;
            if (this.device != null && this.device.online) {
                try {
                    value = this.device.mcc.dioInBit(this.devChan);
                }
                catch (Exception e) {
                    RefrigTestHdw.checkUsbException(e);
                    log.error((Object)("Error reading DIO line: " + e), new String[0]);
                    this.device.setOnline(false);
                }
            }
            return value != 0;
        }
    }

    public static class WuDevc
    extends Device
    implements WattsUp.Listener {
        static final int CHAN_WATTS = 0;
        static final int CHAN_VOLTS = 1;
        static final int N_DEV_CHANS = 2;
        static final int LOG_PERIOD = 1;
        String node;
        String serial;
        WattsUp wtu;
        float[] value;

        public WuDevc(String nodeName, String serialNo) {
            this.type = 1;
            this.node = nodeName;
            this.serial = serialNo;
            this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
            this.value = new float[2];
        }

        @Override
        void initialize(boolean first) {
            block5: {
                try {
                    if (first || this.wtu == null) {
                        this.wtu = new WattsUp();
                        this.wtu.addListener((WattsUp.Listener)this);
                    }
                    this.wtu.open(this.node, 0, this.serial);
                    this.wtu.restart();
                    this.setOnline(true);
                    String message = "Connected to " + this.fullName;
                    if (first) {
                        log.info((Object)message, new String[0]);
                    } else {
                        log.error((Object)message, new String[0]);
                    }
                }
                catch (Exception e) {
                    if (!first) break block5;
                    log.error((Object)("Error connecting to " + this.fullName + ": " + e), new String[0]);
                }
            }
        }

        @Override
        void checkOnline() {
            if (this.online) {
                return;
            }
            this.initialize(false);
        }

        @Override
        void close() {
        }

        public void setPowered(boolean on) {
            if (on) {
                try {
                    this.wtu.setLoggedFields(3);
                    this.wtu.setExternalLogging(1);
                }
                catch (Exception e) {
                    log.error((Object)("Error configuring " + this.fullName + ": " + e), new String[0]);
                }
            } else {
                int j = 0;
                while (j < 2) {
                    this.value[j] = 0.0f;
                    ++j;
                }
            }
        }

        public void setClosed() {
            this.setOnline(false);
            log.error((Object)("Disconnected from " + this.fullName), new String[0]);
        }

        public void processData(float[] data) {
            this.value[0] = data[0];
            this.value[1] = data[1];
        }
    }
}

