/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;

public abstract class RefrigTest
extends Module {
    static final long UPDATE_PERIOD = 1000L;
    Channel[] chanData;
    private String configName = "test";
    private boolean coldStart;
    private boolean running;
    private int loLimChange;
    private int hiLimChange;
    private int setState;
    private int chanState;
    private int chanOnline;

    public RefrigTest(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.initConfiguration();
        this.initSensors();
        this.setOutputLines();
        this.coldStart = false;
        new Timer(true).schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration test system started");
            this.publishState();
            this.publishLimits();
            this.running = true;
        }
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            trendingValues.add(new ValueNotification(ch.getName(), (Object)Float.valueOf(ch.value), timeStamp));
            ++n2;
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState(), timeStamp));
        this.publishData(trendingValues);
    }

    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void setMainPowerEnable(int value) {
        this.setMainPowerEnable(value, true);
    }

    public void setMainPowerEnable(int value, boolean publish) {
        boolean on = false;
        if (value != 0) {
            if ((this.chanState & 0x2000000) == 0) {
                this.setState |= 0x1000000;
                on = true;
            }
        } else {
            this.setState &= 0xFEFFFFFF;
        }
        this.setMainPower(on);
        if (publish) {
            this.publishState();
        }
    }

    public void setLoadTripEnable(int value) {
        this.setState = value != 0 ? (this.setState |= 0x8000000) : (this.setState &= 0xF7FFFFFF);
        this.publishState();
    }

    public void setLowLimit(int id, double limit) throws Exception {
        this.chanData[id].change("limitLo", limit);
    }

    public void setHighLimit(int id, double limit) throws Exception {
        this.chanData[id].change("limitHi", limit);
    }

    public void saveConfiguration() throws IOException {
        this.register(this.configName, "");
        this.loLimChange = 0;
        this.hiLimChange = 0;
        this.publishState();
    }

    public RefrigFullState getFullState() {
        RefrigFullState status = new RefrigFullState();
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            status.addChannel(new RefrigChannel(ch.getName(), ch.description, ch.units, (double)ch.limitLo, (double)ch.limitHi, ch.value));
            ++n2;
        }
        status.setRefrigState(new RefrigState(this.getState(), this.chanOnline, this.loLimChange, this.hiLimChange, this.getTickMillis()));
        return status;
    }

    void setOutputLines() {
        this.setState &= 0xFEFFFFFF;
        if (!this.coldStart && this.isMainPowerOn()) {
            this.setState |= 0x1000000;
        }
        this.setMainPower((this.setState & 0x1000000) != 0);
        this.setLoadPower((this.chanState & 0x4000000) != 0);
        this.setDisplay(-1, this.chanState);
    }

    int getState() {
        return this.setState | this.chanState;
    }

    void publishState() {
        RefrigState refrigState = new RefrigState(this.getState(), this.chanOnline, this.loLimChange, this.hiLimChange, this.getTickMillis());
        this.sendToStatus((Status)new RefrigStateStatus(refrigState));
    }

    void publishLimits() {
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            this.getSubsystem().publishMetaData(ch.getName(), "alarmLow", String.valueOf(ch.limitLo));
            this.getSubsystem().publishMetaData(ch.getName(), "alarmHigh", String.valueOf(ch.limitHi));
            ++n2;
        }
    }

    void checkLimits() {
        int cState = 0x4000000;
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            cState = ch.checkLimits(cState, this.setState);
            ++n2;
        }
        this.chanState ^= (cState ^= this.chanState);
        if (cState != 0) {
            if ((cState & 0x2000000) != 0 && (this.chanState & 0x2000000) != 0) {
                this.setMainPowerEnable(0, false);
            }
            if ((cState & 0x4000000) != 0) {
                this.setLoadPower((this.chanState & 0x4000000) != 0);
            }
            this.setDisplay(cState, this.chanState);
            if (this.running) {
                this.publishState();
                this.tick();
            }
        }
    }

    int findChannelId(String name) {
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            if (ch.getName().equals(name)) {
                return ch.id;
            }
            ++n2;
        }
        return -1;
    }

    Channel getChannel(int id) {
        return this.chanData[id];
    }

    void setOnline(int mask, boolean online) {
        int prevOnline = this.chanOnline;
        this.chanOnline = online ? (this.chanOnline |= mask) : (this.chanOnline &= ~mask);
        if (this.chanOnline != prevOnline) {
            this.publishState();
        }
    }

    static void reportError(String cName, String pName, Object pValue) throws Exception {
        log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName), new String[0]);
        throw new Exception();
    }

    abstract void initConfiguration();

    abstract void initSensors();

    abstract void readSensors();

    abstract void setMainPower(boolean var1);

    abstract void setLoadPower(boolean var1);

    abstract boolean isMainPowerOn();

    abstract boolean isLoadPowerOn();

    abstract void setDisplay(int var1, int var2);

    public static class Channel
    extends ConfigurableComponent {
        String description;
        String units;
        String loCheckS;
        String hiCheckS;
        int loCheck;
        int hiCheck;
        float deadbandLo;
        float deadbandHi;
        float limitLo;
        float limitHi;
        float value;
        boolean trippedLo;
        boolean trippedHi;
        int id;
        RefrigTest refg;
        static final int LIMIT_CHECK_NONE = 0;
        static final int LIMIT_CHECK_FLAG = 1;
        static final int LIMIT_CHECK_MAIN_TRIP = 2;
        static final int LIMIT_CHECK_LOAD_TRIP = 3;
        private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();

        static {
            checkMap.put("NONE", 0);
            checkMap.put("FLAG", 1);
            checkMap.put("MTRIP", 2);
            checkMap.put("LTRIP", 3);
        }

        public Channel(String desc, String units, String loCheck, double limitLo, double deadbandLo, String hiCheck, double limitHi, double deadbandHi) {
            this.description = desc;
            this.units = units;
            this.loCheckS = loCheck;
            this.hiCheckS = hiCheck;
            this.limitLo = (float)limitLo;
            this.deadbandLo = (float)deadbandLo;
            this.limitHi = (float)limitHi;
            this.deadbandHi = (float)deadbandHi;
        }

        void configure(RefrigTest refg, int id) {
            this.refg = refg;
            this.id = id;
            int iLoCheck = 1;
            int iHiCheck = 1;
            try {
                Integer iCheck = checkMap.get(this.loCheckS.toUpperCase());
                if (iCheck == null) {
                    RefrigTest.reportError(this.getName(), "locheck", this.loCheckS);
                }
                iLoCheck = iCheck;
                iCheck = checkMap.get(this.hiCheckS.toUpperCase());
                if (iCheck == null) {
                    RefrigTest.reportError(this.getName(), "hicheck", this.hiCheckS);
                }
                iHiCheck = iCheck;
            }
            catch (Exception exception) {}
            this.loCheck = iLoCheck;
            this.hiCheck = iHiCheck;
        }

        @ConfigChanger
        public void setLimitLo(double limit) {
            float fLimit = (float)limit;
            if (fLimit == this.limitLo) {
                return;
            }
            this.limitLo = fLimit;
            RefrigTest refrigTest = this.refg;
            refrigTest.loLimChange = refrigTest.loLimChange | 1 << this.id;
            this.refg.publishState();
            this.refg.getSubsystem().publishMetaData(this.getName(), "alarmLow", String.valueOf(fLimit));
        }

        @ConfigChanger
        public void setLimitHi(double limit) {
            float fLimit = (float)limit;
            if (fLimit == this.limitHi) {
                return;
            }
            this.limitHi = fLimit;
            RefrigTest refrigTest = this.refg;
            refrigTest.hiLimChange = refrigTest.hiLimChange | 1 << this.id;
            this.refg.publishState();
            this.refg.getSubsystem().publishMetaData(this.getName(), "alarmHigh", String.valueOf(fLimit));
        }

        int checkLimits(int cState, int setState) {
            boolean ok = false;
            if (this.value < this.limitLo) {
                if (this.loCheck == 0) {
                    ok = true;
                } else if (this.loCheck == 2) {
                    cState |= 0x2000000;
                } else if (this.loCheck == 3 && (setState & 0x8000000) != 0) {
                    cState &= 0xFBFFFFFF;
                    this.trippedLo = true;
                }
            } else if (this.value > this.limitHi) {
                if (this.hiCheck == 0) {
                    ok = true;
                } else if (this.hiCheck == 2) {
                    cState |= 0x2000000;
                } else if (this.hiCheck == 3 && (setState & 0x8000000) != 0) {
                    cState &= 0xFBFFFFFF;
                    this.trippedHi = true;
                }
            } else {
                boolean tripped;
                ok = true;
                if (this.loCheck == 3) {
                    tripped = false;
                    if ((setState & 0x8000000) != 0 && this.trippedLo && this.value < this.limitLo + this.deadbandLo) {
                        cState &= 0xFBFFFFFF;
                        tripped = true;
                    }
                    this.trippedLo = tripped;
                }
                if (this.hiCheck == 3) {
                    tripped = false;
                    if ((setState & 0x8000000) != 0 && this.trippedHi && this.value > this.limitHi - this.deadbandHi) {
                        cState &= 0xFBFFFFFF;
                        tripped = true;
                    }
                    this.trippedHi = tripped;
                }
            }
            if (ok) {
                cState |= 1 << this.id;
            }
            return cState;
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            RefrigTest.this.readSensors();
            RefrigTest.this.checkLimits();
        }
    }
}

