package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import static javax.swing.JComponent.*;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Displays the cold plate schematics.
 *
 * @author onoprien
 */
public class CryoPage {

// -- Fields : -----------------------------------------------------------------
    
    private final AgentInfo agent;
    
    private ImageView view;
    private final MonitorField heaterField, otherField;

// -- Life cycle : -------------------------------------------------------------
    
    public CryoPage(AgentInfo agent) {
        
        this.agent = agent;
        
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        fv.format = " %1$6.1f ";
        heaterField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());    
        otherField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys()) {
            @Override
            public FormattedValue format(AgentChannel channel) {
                FormattedValue fv = super.format(channel);
                String s = channel.getPath();
                s = s.substring(s.lastIndexOf("/")+1);
                StringBuilder sb = new StringBuilder();
                if (s.startsWith("C")) {
                    sb.append("Cryo Flex ");
                } else if (s.startsWith("GF")) {
                    sb.append("Grid Flex ");
                } else {
                    sb.append("Grid Bay ");
                }
                sb.append(s.charAt(s.length()-1));
                sb.append(": %1$7.1f ");
                fv.format = sb.toString();
                return fv;
            }
        };
    }
    
    /**
     * Creates a {@code MonitorView} that displays the vacuum plate schematics.
     * @return {@code MonitorView} that displays the vacuum plate schematics.
     */
    public ImageView getView() {
        
        if (view != null) return view;
        
        try {
            
            BufferedImage back = ImageIO.read(getClass().getResource("/cryo.png"));
            view = new ImageView("Cryo Plate", back, .5, 2.);
            
            placeRTD(2, 0.687, 0.577, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(3, 0.687, 0.430, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(4, 0.687, 0.2846, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(12, 0.5945, 0.577, RIGHT_ALIGNMENT, TOP_ALIGNMENT, true);
            placeRTD(13, 0.5945, 0.430, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(14, 0.5945, 0.2846, RIGHT_ALIGNMENT, TOP_ALIGNMENT, true);
            placeRTD(21, 0.5009, 0.7380, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(22, 0.5009, 0.577, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(24, 0.5009, 0.2846, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(25, 0.5009, 0.1401, RIGHT_ALIGNMENT, TOP_ALIGNMENT);
            placeRTD(30, 0.4149, 0.8675, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(31, 0.4149, 0.732, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT, true);
            placeRTD(33, 0.4149, 0.426, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(34, 0.4149, 0.278, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(41, 0.3214, 0.732, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(42, 0.3214, 0.574, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(43, 0.3214, 0.426, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT, true);
            placeRTD(51, 0.2259, 0.732, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(52, 0.2259, 0.574, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            placeRTD(53, 0.2259, 0.426, LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
            
            placeHeaterPower(0, 0.837, 0.8268);
            placeHeaterPower(1, 0.837, 0.7440);
            placeHeaterPower(2, 0.837, 0.5964);
            placeHeaterPower(3, 0.837, 0.4413);
            placeHeaterPower(4, 0.837, 0.3102);
            placeHeaterPower(5, 0.837, 0.2380);
            
            // Total trim power:
            
            String channelPath = agent.getName() +"/Trim_Htrs/CryoTotal_P";
            DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(channelPath, null, null), heaterField);
            CellTableView table = new CellTableView(1, 1, c);
            ImageView.Item item = new ImageView.Item(table);
            item.setPosition(0.92, 0.96);
            item.setAlignment(LEFT_ALIGNMENT, BOTTOM_ALIGNMENT);
//            item.setMaxSize(0.06, 0.029);
            item.setMaxSize(0.08, 0.06);
            view.add(item);
            
            // Other temps:

            DefaultMonitorCell[] cc = new DefaultMonitorCell[2*12];
            int i = 0;
            String name;
            name = "GFX-RTD-01";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GFX-RTD-02";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GFX-RTD-03";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GFX-RTD-04";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "CFX-RTD-01";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "CFX-RTD-02";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "CFX-RTD-03";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "CFX-RTD-04";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GRD-RTD-01";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GRD-RTD-02";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GRD-RTD-03";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);
            name = "GRD-RTD-04";
            cc[i++] = new DefaultMonitorCell(Collections.emptyList(), MonitorField.NULL, new FormattedValue(name, null, null, null, null, false));
            cc[i++] = new DefaultMonitorCell(new DisplayChannelSingle(agent.getName() +"/Grid_Temp/"+ name, null, null), otherField);

            table = new CellTableView(12, 2, cc);
            item = new ImageView.Item(table);
            item.setPosition(0.109, 0.28);
            item.setAlignment(CENTER_ALIGNMENT, TOP_ALIGNMENT);
            item.setMaxSize(0.183, 0.668);
            view.add(item);
            
                        
        } catch (IOException e) {
        }
        return view;
    }
    
    
// -- Local methods : ----------------------------------------------------------
    
    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign, boolean redBorder) throws IOException {
        String channelPath = String.format("%1$s/Cryo_Temp/CYP-RTD-%2$02d", agent.getName(), id);
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        fv.format = "<html><center>RTD-"+ String.format("%02d", id) +":<br>%1$6.1f";
        MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());        
        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(channelPath, null, null), field);
        CellTableView table = new CellTableView(1, 1, c);
        if (redBorder) {
            Insets ins = table.getBorder().getBorderInsets(table);
            table.setBorder(BorderFactory.createMatteBorder(3*ins.top, 3*ins.left, 3*ins.bottom, 3*ins.right, Color.RED));
        }
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(horAlign, vertAlign);
//        item.setMaxSize(0.055, 0.055);
        item.setMaxSize(0.08, 0.064);
        view.add(item);
    }
    
    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign) throws IOException {
        placeRTD(id, x, y, horAlign, vertAlign, false);
    }
    
    private void placeHeaterPower(int id, double x, double y) throws IOException {
        String channelPath = String.format("%1$s/Trim_Htrs/CryoHtr%2$1d_P", agent.getName(), id);
        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(channelPath, null, null), heaterField);
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(LEFT_ALIGNMENT, TOP_ALIGNMENT);
//        item.setMaxSize(0.1260, 0.0375);
        item.setMaxSize(0.1260, 0.06);
        view.add(item);
    }
    
}
