/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

public class BulkSupplyPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final String[] labelNames = new String[]{"Bulk Power:"};
    private static final int HORZ_INSET = UiUtilities.getLabelSize((String)"M").width / 2;
    private final CommandSender sender;
    private final int labelWidth;
    private final int stateWidth;
    private final UiUtilities uiUtils;
    private JLabel controlState;
    private ButtonGroup controlBG;
    private JRadioButton controlOffRB;
    private JRadioButton controlOnRB;
    private static final long serialVersionUID = 1L;

    static int getLabelWidth() {
        return UiUtilities.maxLabelWidth((String[])labelNames, (String)":");
    }

    static int getStateWidth() {
        return UiUtilities.maxEnumLabelWidth(SwitchState.class);
    }

    BulkSupplyPanel(CommandSender sender, int labelWidth, int stateWidth) {
        this.sender = sender;
        this.labelWidth = labelWidth;
        this.stateWidth = stateWidth;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
    }

    public void updatePanel(SwitchState ss) {
        JRadioButton selButton;
        this.controlState.setEnabled(true);
        this.controlState.setText(ss.name());
        this.controlState.setForeground(ss == SwitchState.ON ? UiConstants.GREEN : (ss == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
        this.controlOffRB.setEnabled(true);
        this.controlOnRB.setEnabled(true);
        JRadioButton jRadioButton = ss == SwitchState.ON ? this.controlOnRB : (selButton = ss == SwitchState.OFF ? this.controlOffRB : null);
        if (selButton != null) {
            selButton.setSelected(true);
        }
        this.repaint();
    }

    public void disablePanel() {
        this.controlState.setEnabled(false);
        this.controlOffRB.setEnabled(false);
        this.controlOnRB.setEnabled(false);
        this.repaint();
    }

    private void initComponents() {
        this.controlState = UiUtilities.newLabel((String)"OFF", (int)this.stateWidth);
        this.controlOffRB = this.uiUtils.newRadioButton("Off", "F");
        this.controlOnRB = this.uiUtils.newRadioButton("On", "N");
        this.controlBG = new ButtonGroup();
        this.controlBG.add(this.controlOffRB);
        this.controlBG.add(this.controlOnRB);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, HORZ_INSET, 0, HORZ_INSET);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)UiUtilities.newLabel((String)labelNames[0], (int)this.labelWidth), gbc);
        ++gbc.gridx;
        this.add((Component)this.controlState, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlOffRB, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.add((Component)this.controlOnRB, gbc);
    }

    public void handleRadioButton(String name) {
        this.controlOffRB.setEnabled(false);
        this.controlOnRB.setEnabled(false);
        this.sender.sendCommand(null, "bulkPowerOn", new Object[]{name.charAt(0) == 'N'});
    }
}

