/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;
import hep.aida.util.comparison.AbstractComparisonAlgorithm;
import hep.aida.util.comparison.FiszCramerVonMisesComparisonAlgorithm;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;

public class TikuComparisonAlgorithm
extends AbstractComparisonAlgorithm {
    private static final double precision = 1.0E-10;
    private FiszCramerVonMisesComparisonAlgorithm alg = new FiszCramerVonMisesComparisonAlgorithm();
    private static final String[] names = new String[]{"Tiku"};
    private static final int dType = 2;
    private static final int eType = 1;

    public TikuComparisonAlgorithm() {
        super(2, 1);
    }

    @Override
    public String[] algorithmNames() {
        return names;
    }

    @Override
    public double quality(IComparisonData d1, IComparisonData d2) {
        double quality = this.alg.quality(d1, d2);
        int entries = this.entries(d1);
        double c = 4 * entries - 3;
        double n2 = entries * entries;
        double bNum = 32.0 * n2 - (double)(61 * entries) + 30.0;
        double bDen = (double)(84 * entries) * c;
        double b = bNum / bDen;
        double aNum = 336.0 * n2 - (double)(959 * entries) + 609.0;
        double aDen = 210.0 * bNum;
        double a = aNum / aDen;
        double distance = Math.abs((quality - a) / b);
        double nFreedom = (double)(98 * entries) * Math.pow(c, 3.0) / (5.0 * Math.pow(bNum, 2.0));
        ChiSquaredDistribution chi2Distribution = DistributionFactory.newInstance().createChiSquareDistribution(nFreedom);
        double prob = Double.NaN;
        try {
            prob = chi2Distribution.cumulativeProbability(distance);
        }
        catch (MathException me) {
            throw new RuntimeException("Problems evaluating probability ", me);
        }
        return prob;
    }
}

