/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IFitParameterSettings;
import hep.aida.IFunction;
import hep.aida.dev.IDevFitResult;
import java.util.Hashtable;

public class FitResult
implements IDevFitResult {
    private String[] constraints = null;
    private String dataDescription = "";
    private String engineName = "";
    private String fitMethod = "";
    private Hashtable parSetHash = new Hashtable();
    private int fitStatus = -1;
    private IFunction function = null;
    private boolean isValid = false;
    private int nDof = -1;
    private double quality = Double.NaN;
    private double[][] covMatrix;
    private double seconds;

    public FitResult(int dim) {
        this(dim, Double.NaN);
    }

    public FitResult(int dim, double seconds) {
        this.covMatrix = new double[dim][dim];
        this.seconds = seconds;
    }

    public String[] constraints() {
        return this.constraints;
    }

    public double covMatrixElement(int i, int j) {
        return this.covMatrix[i][j];
    }

    public String dataDescription() {
        return this.dataDescription;
    }

    public String engineName() {
        return this.engineName;
    }

    public String fitMethodName() {
        return this.fitMethod;
    }

    public IFitParameterSettings fitParameterSettings(String parName) {
        return (IFitParameterSettings)this.parSetHash.get(parName);
    }

    public int fitStatus() {
        return this.fitStatus;
    }

    public IFunction fittedFunction() {
        return this.function;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int ndf() {
        return this.nDof;
    }

    public double quality() {
        return this.quality;
    }

    public void setConstraints(String[] constraints) {
        this.constraints = constraints;
    }

    public void setCovMatrixElement(int xCol, int yCol, double covEl) {
        this.covMatrix[xCol][yCol] = covEl;
    }

    public void setDataDescription(String dataDescription) {
        this.dataDescription = dataDescription;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setFitMethodName(String fitMethod) {
        this.fitMethod = fitMethod;
    }

    public void setFitParameterSettings(String parName, IFitParameterSettings parSetting) {
        this.parSetHash.put(parName, parSetting);
    }

    public void setFitStatus(int fitStatus) {
        this.fitStatus = fitStatus;
    }

    public void setFittedFunction(IFunction function) {
        this.function = function;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setNdf(int nDof) {
        this.nDof = nDof;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    public double[] fittedParameters() {
        return this.function.parameters();
    }

    public String[] fittedParameterNames() {
        return this.function.parameterNames();
    }

    public double fittedParameter(String name) {
        return this.function.parameter(name);
    }

    public double[] errors() {
        int dim = this.function.numberOfParameters();
        double[] errors = new double[dim];
        for (int i = 0; i < dim; ++i) {
            errors[i] = Math.sqrt(this.covMatrixElement(i, i));
        }
        return errors;
    }

    public double[] errorsPlus() {
        return this.errors();
    }

    public double[] errorsMinus() {
        return this.errors();
    }

    private String fitStatusToString() {
        switch (this.fitStatus) {
            case 1: {
                return "Diagonal approximation";
            }
            case 2: {
                return "Converged with non positive definite matrix";
            }
            case 3: {
                return "Converged";
            }
            case 4: {
                return "Converged with small gradient";
            }
            case 5: {
                return "Converged with small step size";
            }
            case 6: {
                return "Not Converged";
            }
            case 7: {
                return "Stopped, reached max iterations";
            }
            case 8: {
                return "Stopped, too many large steps. Function might be unbound.";
            }
        }
        return "Undefined";
    }

    public void printResult() {
        int i;
        String[] parNames = this.function.parameterNames();
        System.out.println("************************************************");
        System.out.println("*  Performed " + this.fitMethodName() + " fit using " + this.engineName());
        System.out.println("*  Data Set " + this.dataDescription());
        System.out.println("*  Function " + this.function.codeletString());
        System.out.println("************************************************");
        System.out.println("*  Performance  *");
        System.out.println("*****************");
        System.out.println("*  Status  : " + this.fitStatusToString());
        System.out.println("*  Quality : " + this.quality());
        System.out.println("*  nDoF    : " + this.ndf());
        if (!Double.isNaN(this.seconds)) {
            System.out.println("*  Time    : " + this.seconds + " seconds");
        }
        System.out.println("************************************************");
        System.out.println("*  Parameters  *");
        System.out.println("****************");
        for (i = 0; i < parNames.length; ++i) {
            String parName = parNames[i];
            double parVal = this.function.parameter(parName);
            IFitParameterSettings fitPar = this.fitParameterSettings(parName);
            if (fitPar == null) continue;
            if (!fitPar.isFixed()) {
                double err = Math.sqrt(this.covMatrixElement(i, i));
                if (err != 0.0) {
                    System.out.println("*  " + parName + " : \t " + parVal + "\t " + err);
                    continue;
                }
                System.out.println("*  " + parName + " : \t " + parVal + "\t Constrained");
                continue;
            }
            System.out.println("*  " + parName + " : \t " + parVal + "\t Fixed");
        }
        System.out.println("************************************************");
        System.out.println("*  Covariance Matrix  *");
        System.out.println("***********************");
        System.out.print("*  \t");
        for (i = 0; i < parNames.length; ++i) {
            System.out.print(parNames[i] + "\t");
        }
        System.out.println();
        for (i = 0; i < parNames.length; ++i) {
            System.out.print("*  " + parNames[i] + "\t");
            for (int j = 0; j < parNames.length; ++j) {
                double cov = this.covMatrixElement(i, j);
                if (cov == 0.0) {
                    System.out.print("\t");
                    continue;
                }
                System.out.print(cov + " ");
            }
            System.out.println();
        }
        System.out.println("************************************************\n\n");
    }
}

