package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

/**
 *  Contains the chiller PLC test state, used for updating GUIs
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ChillerPlcTestState implements Serializable {
    
    public static final String KEY = "ChillerPlcTestState";
    private final SwitchState switchState[] = new SwitchState[10];
    private final ChillerPlcState plcState = new ChillerPlcState();

    public void setSwitchState(int sw, SwitchState value) {
        switchState[sw] = value;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public ChillerPlcState getPlcState() {
        return plcState;
    }

    private static final long serialVersionUID = 783423533599550017L;
}
