package org.lsst.ccs.subsystem.refrig.constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

/**
 *  Definitions of the MPM system switches.
 *
 *  @author The CCS team
 */
public class PcpSwitches {

    public static final int
        SW_BLOCK_COLD_REFG  = 0,
        SW_BLOCK_COLD_HEAT  = 1,
        NUM_SWITCHES        = 2,
        SW_ENABLE_HEAT_PS1  = 2,
        SW_ENABLE_HEAT_PS2  = 3,
        SW_ENABLE_HEAT_PS3  = 4,
        NUM_SWITCHES_ALL    = 5;

    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<>();
    static {
        NAME_MAP.put("BlockColdHeat", SW_BLOCK_COLD_HEAT);
        NAME_MAP.put("BlockColdRefg", SW_BLOCK_COLD_REFG);
        //NAME_MAP.put("EnableHeatPS1", SW_ENABLE_HEAT_PS1);
        //NAME_MAP.put("EnableHeatPS2", SW_ENABLE_HEAT_PS2);
        //NAME_MAP.put("EnableHeatPS3", SW_ENABLE_HEAT_PS3);
    }

    private static final Map<Integer, String> ID_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), (String)e.getKey());
        }
    }

    /**
     *  Gets the list of switch names.
     * 
     *  @return  The list of names
     */
    public static List<String> getNames()
    {
        return new ArrayList<>(NAME_MAP.keySet());
    }

    /**
     *  Gets a switch name from its ID.
     * 
     *  @param  id  The switch id
     *  @return  The switch name
     */
    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    /**
     *  Gets a switch ID from its name.
     * 
     *  @param  name  The switch name
     *  @return  The switch ID
     *  @throws  RefrigException
     */
    public static int getId(String name) throws RefrigException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new RefrigException("Invalid switch name: " + name);
        }
        return id;
    }

}
