package org.lsst.ccs.subsystem.refrig.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 *  Definitions for compressor switches.
 * 
 *  @author saxton
 */
public class CompSwitches {
    
    public static final int
        SW_ENABLE          = 0,
        SW_HEATER          = 1,
        SW_LIGHTS          = 2,
        SW_ORIFICE_VALVE   = 3,
        SW_COOLANT_VALVE   = 4,
        SW_BYPASS_VALVE    = 5,
        SW_SURGE_HEATER    = 6,
        SW_ENABLE_ALERTS   = 7,
        SW_CABINET_LIGHT   = 8,
        NUM_SWITCHES       = 9;

    public static final Map<Integer, String> ID_MAP = new LinkedHashMap<>();
    static {
        ID_MAP.put(SW_ENABLE, "Enable");
        ID_MAP.put(SW_ENABLE_ALERTS, "EnableAlerts");
        ID_MAP.put(SW_LIGHTS, "PanelLeds");
        ID_MAP.put(SW_HEATER, "CompSepHtrs");
        ID_MAP.put(SW_ORIFICE_VALVE, "OrificeValve");
        ID_MAP.put(SW_COOLANT_VALVE, "CoolantValve");
        ID_MAP.put(SW_BYPASS_VALVE, "BypassValve");
        ID_MAP.put(SW_SURGE_HEATER, "SurgeHeater");
        ID_MAP.put(SW_CABINET_LIGHT, "CabinetLight");
    }

    public static final Map<String, Integer> NAME_MAP= new LinkedHashMap<>();
    static {
        for (Map.Entry e : ID_MAP.entrySet()) {
            NAME_MAP.put((String)e.getValue(), (int)e.getKey());
        }
    }

    public static final String[] DESCS = new String[NUM_SWITCHES];
    static {
        DESCS[SW_ENABLE]        = "Enable";
        DESCS[SW_LIGHTS]        = "Panel LEDs";
        DESCS[SW_HEATER]        = "Comp/Oil-Sep Htrs";
        DESCS[SW_ORIFICE_VALVE] = "Orifice Valve (NC)";
        DESCS[SW_COOLANT_VALVE] = "Coolant Valve (NO)";
        DESCS[SW_BYPASS_VALVE]  = "Bypass Valve (NC)";
        DESCS[SW_SURGE_HEATER]  = "Surge Tank Heater";
        DESCS[SW_ENABLE_ALERTS] = "Enable Alerts";
        DESCS[SW_CABINET_LIGHT] = "Cabinet Light";
    }

}
