package org.lsst.ccs.subsystem.refrig.constants;

/**
 *  Definitions for compressor conditions.
 * 
 *  @author saxton
 */
public class CompConditions {
    
    public static final int
        COND_KEYSWITCH_ON     = 0,
        COND_CMP_ENABLED      = 1,
        COND_CMP_WAITING      = 2,
        COND_CMP_POWERED      = 3,
        COND_DISC_TEMP_VALID  = 4,
        COND_SUCT_TEMP_VALID  = 5,
        COND_LIQD_TEMP_VALID  = 6,
        COND_DISC_PRESS_VALID = 7,
        COND_SUCT_PRESS_VALID = 8,
        COND_CURRENT_VALID    = 9,
        COND_VOLTAGE_VALID    = 10,
        COND_LATCHES_CLEAR    = 11,
        COND_POWER_LED        = 12,
        COND_CURR_SENSOR_ERR  = 13,
        COND_CMP_ON_8HRS      = 14,
        COND_OIL_LEVEL_VALID  = 15,
        COND_HEATER_ENABLED   = 16,
        COND_HEATER_POWERED   = 17,
        NUM_CONDITIONS        = 18;

    public static final String[] DESCS = new String[NUM_CONDITIONS];
    static {
        DESCS[COND_CMP_ENABLED]      = "Compr enabled";
        DESCS[COND_CMP_WAITING]      = "Compr waiting";
        DESCS[COND_CMP_POWERED]      = "Compr powered";
        DESCS[COND_CURRENT_VALID]    = "Current valid";
        DESCS[COND_DISC_PRESS_VALID] = "Disch press valid";
        DESCS[COND_DISC_TEMP_VALID]  = "Disch temp valid";
        DESCS[COND_KEYSWITCH_ON]     = "Keyswitch on";
        DESCS[COND_LATCHES_CLEAR]    = "Latches clear";
        DESCS[COND_LIQD_TEMP_VALID]  = "Liquid temp valid";
        DESCS[COND_POWER_LED]        = "Power LED On";
        DESCS[COND_SUCT_PRESS_VALID] = "Suctn press valid";
        DESCS[COND_SUCT_TEMP_VALID]  = "Suctn temp valid";
        DESCS[COND_VOLTAGE_VALID]    = "Voltage valid";
        DESCS[COND_CURR_SENSOR_ERR]  = "Current sens err";
        DESCS[COND_CMP_ON_8HRS]      = "Compr on 8 hrs";
        DESCS[COND_OIL_LEVEL_VALID]  = "Oil level valid";
        DESCS[COND_HEATER_ENABLED]   = "Heater enabled";
        DESCS[COND_HEATER_POWERED]   = "Heater powered";
    }

}
