package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.common.data.MonitorTask;

/**
 *  Contains the heat exchanger system state
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class HexState implements Serializable {
    
    public static final String KEY = "HexState";
    private int tickMillis;           // Data status update period (ms)
    private final List<MonitorTask> monTasks = new ArrayList<>();  // Monitor task list
    
    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public int getNumMonTasks() {
        return monTasks.size();
    }

    public void addMonitorTask(MonitorTask task) {
        monTasks.add(task);
    }

    public List<MonitorTask> getMonitorTasks() {
        return monTasks;
    }

    public MonitorTask getMonitorTask(int num) {
        return monTasks.get(num);
    }

    public void clearMonitorTasks() {
        monTasks.clear();
    }

    @Override
    public String toString() {
        return super.toString();  // Replace this
    }

    private static final long serialVersionUID = 4410673690320662283L;
}
