package org.lsst.ccs.subsystem.refrig.constants;

/**
 *  Definitions for compressor latches.
 * 
 *  @author saxton
 */
public class CompLatches {
    
    public static final int
        LATCH_DISCHARGE_TEMP  = 0,
        LATCH_SUCTION_TEMP    = 1,
        LATCH_LIQUID_TEMP     = 2,
        LATCH_DISCHARGE_PRESS = 3,
        LATCH_POWER           = 4,
        LATCH_EXT_PERMIT      = 5,
        LATCH_SMOKE_DETC      = 6,
        LATCH_SENSORS_VALID   = 7,
        LATCH_AFTER_COOLER    = 8,
        LATCH_OIL_LEVEL       = 9,
        NUM_LATCHES           = 10;

    public static final String[] DESCS = new String[NUM_LATCHES];
    static {
        DESCS[LATCH_DISCHARGE_PRESS] = "Discharge Press";
        DESCS[LATCH_DISCHARGE_TEMP]  = "Discharge Temp";
        DESCS[LATCH_EXT_PERMIT]      = "External Permit";
        DESCS[LATCH_LIQUID_TEMP]     = "Liquid Temp";
        DESCS[LATCH_POWER]           = "Compressr Power";
        DESCS[LATCH_SENSORS_VALID]   = "Sensor Readings";
        DESCS[LATCH_SMOKE_DETC]      = "Smoke Detector";
        DESCS[LATCH_SUCTION_TEMP]    = "Suction Temp";
        DESCS[LATCH_AFTER_COOLER]    = "After Cooler Temp";
        DESCS[LATCH_OIL_LEVEL]       = "Oil Level";
    }

}
