package org.lsst.ccs.subsystem.refrig.data;

import org.lsst.ccs.bus.annotations.SkipEncoding;
import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.refrig.constants.ChillerConditions;
import org.lsst.ccs.subsystem.refrig.constants.ChillerLatches;
import org.lsst.ccs.subsystem.refrig.constants.ChillerPLCState;
import org.lsst.ccs.subsystem.refrig.constants.ChillerSwitches;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

/**
 *  Contains the state of the protection subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ChillerPlcState implements Serializable {
    
    private ChillerPLCState plcState = ChillerPLCState.STOPPED;  // PLC state
    private final SwitchState[] switchState = new SwitchState[ChillerSwitches.NUM_SWITCHES];  // Switch state array
    private final LatchState[] latchState = new LatchState[ChillerLatches.NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[ChillerConditions.NUM_CONDITIONS];  // PLC conditions array

    public ChillerPlcState() {
        Arrays.fill(switchState, SwitchState.OFF);
        Arrays.fill(latchState, LatchState.CLEAR);
        Arrays.fill(conditionState, ConditionState.YES);
    }

    public void setPlcState(ChillerPLCState value) {
        plcState = value;
    }

    public ChillerPLCState getPlcState() {
        return plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    private static final long serialVersionUID = -8025759035234214279L;
}
